/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing;

import org.xwiki.extension.DefaultExtensionDependency;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.extension.version.internal.DefaultVersionConstraint;

public class LicensedFeatureId {
    private static final VersionConstraint NO_VERSION_CONSTRAINT = new DefaultVersionConstraint("(,)");
    private final String id;
    private final VersionConstraint versionConstraint;

    public LicensedFeatureId(String id) {
        this(id, null);
    }

    public LicensedFeatureId(String id, String versionConstraint) {
        if (id == null) {
            throw new NullPointerException("LicensedExtensionId requires a non-null identifier");
        }
        this.id = id;
        this.versionConstraint = versionConstraint != null ? new DefaultVersionConstraint(versionConstraint) : NO_VERSION_CONSTRAINT;
    }

    public String getId() {
        return this.id;
    }

    public String getVersionConstraint() {
        return this.versionConstraint == NO_VERSION_CONSTRAINT ? null : this.versionConstraint.getValue();
    }

    public ExtensionDependency getExtensionDependency() {
        return new DefaultExtensionDependency(this.id, this.versionConstraint);
    }

    public boolean isCompatible(ExtensionId extensionId) {
        return this.id.equals(extensionId.getId()) && this.versionConstraint.isCompatible(extensionId.getVersion());
    }

    public String toString() {
        return "<" + this.id + "-" + String.valueOf(this.versionConstraint) + ">";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LicensedFeatureId)) {
            return false;
        }
        LicensedFeatureId licensedFeatureId = (LicensedFeatureId)obj;
        return this.id.equals(licensedFeatureId.id) && (this.versionConstraint == null && licensedFeatureId.versionConstraint == null || this.versionConstraint != null && this.versionConstraint.equals(licensedFeatureId.versionConstraint));
    }

    public int hashCode() {
        return super.hashCode();
    }
}

