/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing;

import com.xwiki.licensing.LicenseId;
import com.xwiki.licensing.LicenseType;
import com.xwiki.licensing.LicensedFeatureId;
import com.xwiki.licensing.SignedLicense;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.xwiki.instance.InstanceId;

public class License
implements Comparable<License> {
    public static final String LICENSEE_FIRST_NAME = "firstName";
    public static final String LICENSEE_LAST_NAME = "lastName";
    public static final String LICENSEE_EMAIL = "email";
    public static final License UNLICENSED = new License();
    private LicenseId licenseId;
    private Collection<LicensedFeatureId> featureIds;
    private Collection<InstanceId> instanceIds;
    private long expirationDate = Long.MAX_VALUE;
    private long maxUserCount = Long.MAX_VALUE;
    private LicenseType licenseType = LicenseType.FREE;
    private Map<String, String> licensee;

    public License() {
    }

    public License(License license) {
        this.setId(license.getId());
        this.setType(license.getType());
        this.setFeatureIds(license.getFeatureIds());
        this.setInstanceIds(license.getInstanceIds());
        this.setExpirationDate(license.getExpirationDate());
        this.setMaxUserCount(license.getMaxUserCount());
        this.setLicensee(license.getLicensee());
    }

    public LicenseId getId() {
        if (this.licenseId == null) {
            this.licenseId = new LicenseId();
        }
        return this.licenseId;
    }

    public void setId(LicenseId id) {
        this.licenseId = id;
    }

    public Collection<LicensedFeatureId> getFeatureIds() {
        return this.featureIds != null ? Collections.unmodifiableCollection(this.featureIds) : Collections.emptySet();
    }

    public void setFeatureIds(Collection<LicensedFeatureId> ids) {
        if (ids != null) {
            this.featureIds = new HashSet<LicensedFeatureId>();
            this.featureIds.addAll(ids);
        } else {
            this.featureIds = null;
        }
    }

    public void addFeatureId(LicensedFeatureId id) {
        if (this.featureIds == null) {
            this.featureIds = new HashSet<LicensedFeatureId>();
        }
        this.featureIds.add(id);
    }

    public Collection<InstanceId> getInstanceIds() {
        return this.instanceIds != null ? Collections.unmodifiableCollection(this.instanceIds) : Collections.emptySet();
    }

    public void setInstanceIds(Collection<InstanceId> ids) {
        if (ids != null) {
            this.instanceIds = new HashSet<InstanceId>();
            this.instanceIds.addAll(ids);
        } else {
            this.instanceIds = null;
        }
    }

    public void addInstanceId(InstanceId id) {
        if (this.instanceIds == null) {
            this.instanceIds = new HashSet<InstanceId>();
        }
        this.instanceIds.add(id);
    }

    public boolean isApplicableTo(InstanceId id) {
        return this.instanceIds != null && this.instanceIds.contains(id);
    }

    public long getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Long date) {
        this.expirationDate = date;
    }

    public long getMaxUserCount() {
        return this.maxUserCount;
    }

    public void setMaxUserCount(long userCount) {
        this.maxUserCount = userCount;
    }

    public LicenseType getType() {
        return this.licenseType;
    }

    public void setType(LicenseType type) {
        this.licenseType = type;
    }

    public Map<String, String> getLicensee() {
        return this.licensee != null ? Collections.unmodifiableMap(this.licensee) : Collections.emptyMap();
    }

    public void setLicensee(Map<String, String> licensee) {
        if (licensee != null) {
            this.licensee = new LinkedHashMap<String, String>();
            this.licensee.putAll(licensee);
        } else {
            this.licensee = null;
        }
    }

    public void addLicenseeInfo(String key, String value) {
        if (this.licensee == null) {
            this.licensee = new LinkedHashMap<String, String>();
        }
        this.licensee.put(key, value);
    }

    public static License getOptimumLicense(License license1, License license2) {
        if (license1 == null) {
            return license2;
        }
        if (license2 == null) {
            return license1;
        }
        if (license1 instanceof SignedLicense) {
            if (!(license2 instanceof SignedLicense)) {
                return license1;
            }
        } else if (license2 instanceof SignedLicense) {
            return license2;
        }
        if (Objects.equals(license1.getId(), license2.getId())) {
            return license1;
        }
        if (license1.getExpirationDate() != license2.getExpirationDate()) {
            return license1.getExpirationDate() >= license2.getExpirationDate() ? license1 : license2;
        }
        if (license1.getMaxUserCount() != license2.getMaxUserCount()) {
            return license1.getMaxUserCount() >= license2.getMaxUserCount() ? license1 : license2;
        }
        if (license1.getType() != license2.getType()) {
            return license1.getType().compareTo(license2.getType()) >= 0 ? license1 : license2;
        }
        if (license1.getFeatureIds().size() != license2.getFeatureIds().size()) {
            return license1.getFeatureIds().size() >= license2.getFeatureIds().size() ? license1 : license2;
        }
        if (license1.getInstanceIds().size() != license2.getInstanceIds().size()) {
            return license1.getInstanceIds().size() >= license2.getInstanceIds().size() ? license1 : license2;
        }
        return license1;
    }

    public static License getOptimumLicense(Collection<License> licenses) {
        License bestLicense = null;
        for (License license : licenses) {
            bestLicense = License.getOptimumLicense(bestLicense, license);
        }
        return bestLicense;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        License license = (License)obj;
        return new CollectionEqualsBuilder().append(this.getId(), license.getId()).append((Object)this.getType(), (Object)license.getType()).append(this.getInstanceIds(), license.getInstanceIds()).append(this.getFeatureIds(), license.getFeatureIds()).append(this.getExpirationDate(), license.getExpirationDate()).append(this.getMaxUserCount(), license.getMaxUserCount()).append(this.getLicensee(), license.getLicensee()).isEquals();
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public int compareTo(License o) {
        return this.getId().compareTo(this.getId());
    }

    static {
        UNLICENSED.setId(new LicenseId("00000000-0000-0000-0000-000000000000"));
        UNLICENSED.setExpirationDate(0L);
        UNLICENSED.setMaxUserCount(0L);
    }

    private static class CollectionEqualsBuilder
    extends EqualsBuilder {
        private CollectionEqualsBuilder() {
        }

        public EqualsBuilder append(Object lhs, Object rhs) {
            if (!this.isEquals()) {
                return this;
            }
            if (lhs == rhs) {
                return this;
            }
            if (!(lhs instanceof Collection) || lhs.getClass() != rhs.getClass()) {
                return super.append(lhs, rhs);
            }
            return this.append((Collection)lhs, (Collection)rhs);
        }

        private EqualsBuilder append(Collection<?> lhs, Collection<?> rhs) {
            if (lhs.size() != rhs.size()) {
                this.setEquals(false);
                return this;
            }
            if (lhs.size() > 0) {
                return this.appendCollection(lhs, rhs);
            }
            return this;
        }

        private EqualsBuilder appendCollection(Collection<?> lhs, Collection<?> rhs) {
            for (Object lobj : lhs) {
                boolean found = false;
                for (Object robj : rhs) {
                    if (!lobj.equals(robj)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.setEquals(false);
                return this;
            }
            return this;
        }
    }
}

