/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.licensing.test.internal;

import com.xwiki.licensing.License;
import com.xwiki.licensing.SignedLicense;
import com.xwiki.licensing.test.SignedLicenseTestUtils;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.crypto.AsymmetricKeyFactory;
import org.xwiki.crypto.BinaryStringEncoder;
import org.xwiki.crypto.params.cipher.CipherParameters;
import org.xwiki.crypto.params.cipher.asymmetric.PrivateKeyParameters;
import org.xwiki.crypto.params.cipher.asymmetric.PublicKeyParameters;
import org.xwiki.crypto.pkix.CertificateFactory;
import org.xwiki.crypto.pkix.CertificateGeneratorFactory;
import org.xwiki.crypto.pkix.CertificateProvider;
import org.xwiki.crypto.pkix.params.CertificateGenerationParameters;
import org.xwiki.crypto.pkix.params.CertificateParameters;
import org.xwiki.crypto.pkix.params.CertifiedKeyPair;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.pkix.params.PrincipalIndentifier;
import org.xwiki.crypto.pkix.params.x509certificate.DistinguishedName;
import org.xwiki.crypto.pkix.params.x509certificate.X509CertificateGenerationParameters;
import org.xwiki.crypto.pkix.params.x509certificate.X509CertificateParameters;
import org.xwiki.crypto.pkix.params.x509certificate.X509CertifiedPublicKey;
import org.xwiki.crypto.signer.SignerFactory;
import org.xwiki.properties.converter.Converter;

@Component
@Singleton
public class DefaultSignedLicenseTestUtils
implements SignedLicenseTestUtils,
Initializable {
    private static final String RSA_PRIVATE_KEY = "MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDCmjim/3likJ4VF564UyygqPjIX/z090AImLl0fDLUkIyCVTSd18wJ3axr1qjLtSgNPWet0puSxOFH0AzFKRCJOjUkQRU8iAkz64MLAf9xrx4nBECciqeB941s01kLtG8C/UqC3O9SwHSdhtUpUU8V/91SiD09yNJsnODi3WqM3oLg1QYzKhoaD2mVo2xJLQ/QXqr2XIc5i2Mlpfq6S5JNbFD/I+UFhBUlBNuDOEV7ttIt2eFMEUsfkCestGo0YoQYOpTLPcPGRS7MnSY1CLWGUYqaMSnes0nS8ke2PPD4Q0suAZz4msnhNufanscstM8tcNtsZF6hj0JvbZok89szAgMBAAECggEBAKWJ1SlR5ysORDtDBXRc5HiiZEbnSGIFtYXajN/nCsJBWBVCb+jZeirmU9bEGoB20OQ6WOjHYCnAqraQ51wMK5HgXvZBGtSMD/AHpkiF4YsOYULlXiUL2aQ4NijdvEC1sz1Cw9CAKmElb83UtZ1ZGkJnjhi35giZvU5BQRgbK5k57DFY66yv9VDg8tuD/enI9sRsCUZfCImuShGv4nLqhPMPg+1UxDPGetVs8uEaJQ017E14wLKLA0DlED13icelU1A7ufkEdeBSv/yZ7ENjervzPwa9nITK/19uzqaHOcYZxmDQn6UHTnaLpIEaUvpp/pbed5S97ETSsqUBC8fqEUECgYEA/Sbao6efydhlXDHbXtyvaJWao19sbI9OfxGC6dR2fZiBx8Do9kVDDbMtb1PYEfLhYbiurmKGbUtcLSFgxNbZifUmG54M92nBsnsetMCqvMVNzYl2Je83V+NrIsLJjFIZ2CBvZa/FKOLDTwSe35fNqaS0ExdwcGNMIT//bDQCmyECgYEAxMq6rN+HpBRuhvvstV99zV+lI/1DzZuXExd+c3PSchiqkJrTLaQDvcaHQir9hK7RqF9vO7tvdluJjgX+f/CMPNQuC5k6vY/0fS4V2NQWtln9BBSzHtocTnZzFNq8tAZqyEhZUHIbkncroXveUXqtlfOnKB2aYI/+3gPEMYJlH9MCgYA4exjA9r9B65QB0+Xb7mT8cpSD6uBoADlFRITu4sZlE0exZ6sSdzWUsutqMUy+BHCguvHOWpEfhXbVYuMSR9VVYGrWMpc2BFSBG9MoBOyTHXpUZ10C7bJtW4IlyUvqkM7PV71C9MqKar2kvaUswdPTC7pZoBsoGB9+M6crXxdNwQKBgDUVMlGbYi1CTaYfonQyM+8IE7WnhXiatZ+ywKtH3MZmHOwwtzIigdfZC3cvvX7i4S73vztvjdtxSaODvmiobEukOF9sj8m+YQa7Pa1lWFML5xIIu2BhGS2ZCeXgMvKkoH0x9tWaUhGqD5zZmtiDrPs75CUQBypw7SDaBzwLnld9AoGBAPgUh90PvUzbVVkzpVCPI82cmOIVMI1rDE6uCeNzIlN6Xu80RimCSaaDsESitBtoVWLRWWmuCINyqr6e9AdyvbvT6mQCjbn9+y7t6ZAhLaya5ZMUVEBLyLLqMzry oi/huj7m4nV4kPZz9LKxDRu3r6o0Pah+daDsTxEYObtsKa7e";
    private static final String RSA_PUBLIC_KEY = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwpo4pv95YpCeFReeuFMsoKj4yF/89PdACJi5dHwy1JCMglU0ndfMCd2sa9aoy7UoDT1nrdKbksThR9AMxSkQiTo1JEEVPIgJM+uDCwH/ca8eJwRAnIqngfeNbNNZC7RvAv1KgtzvUsB0nYbVKVFPFf/dUog9PcjSbJzg4t1qjN6C4NUGMyoaGg9plaNsSS0P0F6q9lyHOYtjJaX6ukuSTWxQ/yPlBYQVJQTbgzhFe7bSLdnhTBFLH5AnrLRqNGKEGDqUyz3DxkUuzJ0mNQi1hlGKmjEp3rNJ0vJHtjzw+ENLLgGc+JrJ4Tbn2p7HLLTPLXDbbGReoY9Cb22aJPPbMwIDAQAB";
    private static final String SIGNED_LICENSE = "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";
    @Inject
    @Named(value="Base64")
    private BinaryStringEncoder base64encoder;
    @Inject
    @Named(value="RSA")
    private AsymmetricKeyFactory rsaKeyFactory;
    @Inject
    @Named(value="X509")
    private CertificateFactory certFactory;
    @Inject
    private Converter<License> converter;
    @Inject
    @Named(value="SHA256withRSAEncryption")
    private SignerFactory rsaSignerFactory;
    @Inject
    @Named(value="X509")
    private CertificateGeneratorFactory certificateFactory;
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
    private CertifiedKeyPair keyPair;
    private CertificateProvider certProvider;
    private SignedLicense signedLicense;
    private X509CertifiedPublicKey caKey;

    public void initialize() throws InitializationException {
        try {
            PrivateKeyParameters rsaPrivateKey = this.rsaKeyFactory.fromPKCS8(this.base64encoder.decode(RSA_PRIVATE_KEY));
            PublicKeyParameters rsaPublicKey = this.rsaKeyFactory.fromX509(this.base64encoder.decode(RSA_PUBLIC_KEY));
            CertifiedPublicKey v3Certificate = this.certificateFactory.getInstance(this.rsaSignerFactory.getInstance(true, (CipherParameters)rsaPrivateKey), (CertificateGenerationParameters)new X509CertificateGenerationParameters(null)).generate((PrincipalIndentifier)new DistinguishedName((Object)"CN=Test"), rsaPublicKey, (CertificateParameters)new X509CertificateParameters());
            this.caKey = (X509CertifiedPublicKey)v3Certificate;
            this.keyPair = new CertifiedKeyPair(rsaPrivateKey, (CertifiedPublicKey)this.caKey);
            this.certProvider = new ArrayBasedCertificateProvider(Collections.singletonList(this.caKey));
            this.signedLicense = (SignedLicense)this.converter.convert(License.class, (Object)this.base64encoder.decode(SIGNED_LICENSE));
        }
        catch (Exception e) {
            throw new InitializationException("Unable to initialized Signed License tests", (Throwable)e);
        }
    }

    @Override
    public CertifiedKeyPair getSigningKeyPair() {
        return this.keyPair;
    }

    @Override
    public SignerFactory getSignerFactory() {
        return this.rsaSignerFactory;
    }

    @Override
    public CertificateProvider getCertificateProvider() {
        return this.certProvider;
    }

    @Override
    public CertifiedPublicKey getRootCertificate() {
        return this.caKey;
    }

    @Override
    public CertifiedPublicKey getIntermediateCertificate() {
        return this.caKey;
    }

    @Override
    public CertifiedPublicKey getSigningCertificate() {
        return this.caKey;
    }

    @Override
    public SignedLicense getSignedLicense() {
        return this.signedLicense;
    }

    @Override
    public Converter<License> getLicenseConverter() {
        return this.converter;
    }

    private class ArrayBasedCertificateProvider
    implements CertificateProvider {
        Collection<X509CertifiedPublicKey> certs = new ArrayList<X509CertifiedPublicKey>();

        public ArrayBasedCertificateProvider(Collection<CertifiedPublicKey> certs) {
            for (CertifiedPublicKey cert : certs) {
                this.certs.add((X509CertifiedPublicKey)cert);
            }
        }

        public CertifiedPublicKey getCertificate(byte[] keyIdentifier) {
            for (X509CertifiedPublicKey cert : this.certs) {
                if (!Arrays.equals(cert.getSubjectKeyIdentifier(), keyIdentifier)) continue;
                return cert;
            }
            return null;
        }

        public CertifiedPublicKey getCertificate(PrincipalIndentifier issuer, BigInteger serial) {
            for (X509CertifiedPublicKey cert : this.certs) {
                if (!cert.getIssuer().equals((Object)issuer) || !cert.getSerialNumber().equals(serial)) continue;
                return cert;
            }
            return null;
        }

        public CertifiedPublicKey getCertificate(PrincipalIndentifier issuer, BigInteger serial, byte[] keyIdentifier) {
            for (X509CertifiedPublicKey cert : this.certs) {
                if (!cert.getIssuer().equals((Object)issuer) || !cert.getSerialNumber().equals(serial) || !Arrays.equals(cert.getSubjectKeyIdentifier(), keyIdentifier)) continue;
                return cert;
            }
            return null;
        }

        public Collection<CertifiedPublicKey> getCertificate(PrincipalIndentifier subject) {
            ArrayList<CertifiedPublicKey> result = new ArrayList<CertifiedPublicKey>();
            for (X509CertifiedPublicKey cert : this.certs) {
                if (!cert.getSubject().equals((Object)subject)) continue;
                result.add((CertifiedPublicKey)cert);
            }
            return result;
        }
    }
}

