/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.jirapro.oauth.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xwiki.jirapro.oauth.internal.JIRAOAuthAuthenticator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.contrib.jira.config.JIRAAuthenticator;
import org.xwiki.contrib.jira.config.JIRAAuthenticatorFactory;
import org.xwiki.contrib.jira.config.internal.JIRAAuthenticatorException;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;

@Singleton
@Component
@Named(value="oauth")
public class JIRAOAuthAuthenticatorFactory
implements JIRAAuthenticatorFactory {
    private static final List<String> JIRA_PRO_OAUTH_SPACE = List.of("XWiki", "JIRAPro", "OAuth");
    private static final String CONFIG_ID_FIELD = "id";
    public static final LocalDocumentReference OAUTH_CONFIG_REFERENCE = new LocalDocumentReference(JIRA_PRO_OAUTH_SPACE, "Config");
    public static final LocalDocumentReference OAUTH_DATA_CLASS_REFERENCE = new LocalDocumentReference(JIRA_PRO_OAUTH_SPACE, "ConfigClass");
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private Provider<XWikiContext> contextProvider;

    public JIRAAuthenticator get(String serverId) throws JIRAAuthenticatorException {
        XWikiDocument doc;
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        try {
            doc = context.getWiki().getDocument((EntityReference)OAUTH_CONFIG_REFERENCE, context);
        }
        catch (XWikiException e) {
            throw new JIRAAuthenticatorException("Can't get JIRA OAuth configuration document", (Throwable)e);
        }
        BaseObject authObj = doc.getXObject((EntityReference)OAUTH_DATA_CLASS_REFERENCE, CONFIG_ID_FIELD, serverId, false);
        if (authObj != null) {
            JIRAOAuthAuthenticator authenticator;
            int requireAuthentication = authObj.getIntValue("requireAuthentication");
            String configName = authObj.getStringValue("oidcConfigName");
            try {
                authenticator = (JIRAOAuthAuthenticator)((ComponentManager)this.componentManagerProvider.get()).getInstance(JIRAAuthenticator.class, "oauth");
            }
            catch (ComponentLookupException e) {
                throw new JIRAAuthenticatorException("Can't get OAuthAuthenticator component", (Throwable)e);
            }
            authenticator.configure(configName, requireAuthentication == 1);
            return authenticator;
        }
        throw new JIRAAuthenticatorException("Can't find OAuth config for server ID: " + serverId);
    }
}

