/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.jirapro.oauth.internal;

import com.atlassian.jira.rest.client.api.AuthenticationHandler;
import com.xpn.xwiki.XWikiContext;
import com.xwiki.licensing.Licensor;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.hc.client5.http.ContextBuilder;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.core5.http.HttpHost;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.contrib.jira.config.JIRAAuthenticator;
import org.xwiki.contrib.oidc.OAuth2ClientManager;
import org.xwiki.contrib.oidc.OAuth2Token;
import org.xwiki.contrib.oidc.OAuth2TokenStore;
import org.xwiki.contrib.oidc.auth.store.OIDCClientConfiguration;
import org.xwiki.contrib.oidc.auth.store.OIDCClientConfigurationStore;
import org.xwiki.job.Job;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.SpaceBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
@Named(value="oauth")
public class JIRAOAuthAuthenticator
implements JIRAAuthenticator {
    public static final String HINT = "oauth";
    private static final String BLOCK_PARAM_CLASS = "class";
    private static final String BLOCK_PARAM_CLASS_VALUE_WARNINGMESSAGE = "box warningmessage";
    private static final String QUERY_STRING = "queryString";
    private String configurationName;
    private boolean isRequiringAuthentication;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private OIDCClientConfigurationStore clientConfigurationStore;
    @Inject
    private OAuth2ClientManager oAuth2ClientManager;
    @Inject
    private OAuth2TokenStore tokenStore;
    @Inject
    private Logger logger;
    @Inject
    private ContextualLocalizationManager localization;
    @Inject
    private Licensor licensor;

    public void configure(String configurationName, boolean isRequiringAuthentication) {
        this.configurationName = configurationName;
        this.isRequiringAuthentication = isRequiringAuthentication;
    }

    public AuthenticationHandler getRestClientAuthenticationHandler() {
        throw new RuntimeException("Feature not supported to configure a AuthenticationHandler for OAuth");
    }

    public void authenticateInHttpClient(ContextBuilder context, HttpUriRequest request, HttpHost targetHost) {
        Optional<String> token = this.getOAuthToken();
        token.ifPresent(s -> request.setHeader("Authorization", (Object)("Bearer " + s)));
    }

    public boolean isAuthenticatingRequest() {
        return this.getOAuthToken().isPresent();
    }

    public String getId() {
        return this.configurationName;
    }

    public Optional<String> getOAuthToken() {
        if (!this.licensor.hasLicensure((EntityReference)new DocumentReference(((XWikiContext)this.contextProvider.get()).getWikiId(), List.of("XWiki", "JIRAPro", "OAuth"), "WebHome"))) {
            return Optional.empty();
        }
        if (((XWikiContext)this.contextProvider.get()).getUserReference() == null) {
            return Optional.empty();
        }
        try {
            OAuth2Token token;
            OIDCClientConfiguration configuration = this.clientConfigurationStore.getOIDCClientConfiguration(this.configurationName);
            Job tokenRenewalJob = this.oAuth2ClientManager.renew(configuration);
            if (tokenRenewalJob != null) {
                try {
                    tokenRenewalJob.join();
                }
                catch (InterruptedException e) {
                    this.logger.error("Can't get renewal job", (Throwable)e);
                    return Optional.empty();
                }
            }
            if ((token = this.tokenStore.getToken(configuration)) != null) {
                return Optional.of(token.getAccessToken());
            }
            return Optional.empty();
        }
        catch (Exception e) {
            this.logger.error("Can't get OAuth token", (Throwable)e);
            return Optional.empty();
        }
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public boolean isRequiringAuthentication() {
        return this.isRequiringAuthentication;
    }

    public Block getWarningMacroBlock(boolean mustBeAuthenticated, boolean isInline, String redirectUrl) {
        ResourceReference reference;
        String linkTranslationKey;
        String descriptionTranslationKey;
        boolean isUserLoggedIn;
        if (this.isAuthenticatingRequest()) {
            return isInline ? new FormatBlock() : new GroupBlock();
        }
        boolean bl = isUserLoggedIn = ((XWikiContext)this.contextProvider.get()).getUserReference() != null;
        if (mustBeAuthenticated) {
            descriptionTranslationKey = isUserLoggedIn ? "com.xwiki.jirapro.oauth.mustbeauthenticated.jira.description" : "com.xwiki.jirapro.oauth.mustbeauthenticated.xwiki.description";
            linkTranslationKey = isUserLoggedIn ? "com.xwiki.jirapro.oauth.mustbeauthenticated.jira.link" : "com.xwiki.jirapro.oauth.mustbeauthenticated.xwiki.link";
        } else {
            descriptionTranslationKey = isUserLoggedIn ? "com.xwiki.jirapro.oauth.mightneedtoauthenticate.jira.description" : "com.xwiki.jirapro.oauth.mightneedtoauthenticate.xwiki.description";
            linkTranslationKey = isUserLoggedIn ? "com.xwiki.jirapro.oauth.mightneedtoauthenticate.jira.link" : "com.xwiki.jirapro.oauth.mightneedtoauthenticate.xwiki.link";
        }
        String configId = this.getConfigurationName();
        ResourceReference resourceReference = reference = isUserLoggedIn ? new ResourceReference("XWiki.JIRAPro.OAuth.JiraAuthorize", ResourceType.DOCUMENT) : new ResourceReference("/xwiki/bin/login/XWiki/XWikiLogin?xredirect=" + URLEncoder.encode(redirectUrl, StandardCharsets.UTF_8), ResourceType.PATH);
        if (isUserLoggedIn) {
            reference.setParameter(QUERY_STRING, "configId=" + URLEncoder.encode(configId, StandardCharsets.UTF_8) + "&redirectUrl=" + URLEncoder.encode(redirectUrl, StandardCharsets.UTF_8));
        }
        LinkBlock link = new LinkBlock(this.localization.getTranslation(linkTranslationKey).render(new Object[0]).getChildren(), reference, false);
        List<WordBlock> blocks = List.of(this.localization.getTranslation(descriptionTranslationKey).render(new Object[0]), new SpaceBlock(), link, new WordBlock("."));
        if (isInline) {
            return new FormatBlock(blocks, Format.NONE, Map.of(BLOCK_PARAM_CLASS, BLOCK_PARAM_CLASS_VALUE_WARNINGMESSAGE));
        }
        return new GroupBlock(blocks, Map.of(BLOCK_PARAM_CLASS, BLOCK_PARAM_CLASS_VALUE_WARNINGMESSAGE));
    }
}

