/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.jirapro.oauth.internal.transformation;

import com.xpn.xwiki.XWikiContext;
import com.xwiki.jirapro.oauth.internal.JIRAOAuthAuthenticator;
import com.xwiki.licensing.Licensor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.xwiki.contrib.jira.config.JIRAServer;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.transformation.MacroTransformationContext;

public class JIRAMacroTransformation<P>
implements org.xwiki.contrib.jira.macro.JIRAMacroTransformation<P> {
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Licensor licensor;

    public List<Block> transform(List<Block> blocks, P parameters, MacroTransformationContext context, JIRAServer jiraServer, String macroName) {
        XWikiContext xcontext = (XWikiContext)this.contextProvider.get();
        if (jiraServer.getJiraAuthenticator().isEmpty() || !(jiraServer.getJiraAuthenticator().get() instanceof JIRAOAuthAuthenticator)) {
            return blocks;
        }
        if (!this.licensor.hasLicensure((EntityReference)new DocumentReference(xcontext.getWikiId(), List.of("XWiki", "JIRAPro", "OAuth"), "WebHome"))) {
            return List.of(new MacroBlock("missingLicenseMessage", Map.of("extensionName", "com.xwiki.jirapro.oauth.extension.name"), null, context.isInline()));
        }
        JIRAOAuthAuthenticator authenticator = (JIRAOAuthAuthenticator)jiraServer.getJiraAuthenticator().get();
        if (authenticator.isAuthenticatingRequest()) {
            return blocks;
        }
        if (authenticator.isRequiringAuthentication()) {
            return List.of(authenticator.getWarningMacroBlock(true, context.isInline(), xcontext.getURL().toString()));
        }
        ArrayList<Block> result = new ArrayList<Block>(blocks);
        result.add(authenticator.getWarningMacroBlock(false, context.isInline(), xcontext.getURL().toString()));
        return result;
    }
}

