/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.jirapro.issuecreate.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xwiki.jirapro.issuecreate.internal.JiraIssueCreationException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hc.client5.http.ContextBuilder;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.xwiki.contrib.jira.config.JIRAServer;

public class JiraIssueCreationRestClient {
    private static final String APPLICATION_JSON = "application/json";
    private static final String CLIENT_CLOSE_FAILURE = "Failed to close client.";
    private static final String START_AT = "startAt";
    private static final String MAX_RESULTS = "maxResults";
    private static final String TOTAL = "total";
    private static final String IS_LAST = "isLast";
    private static final String VALUES = "values";
    private JIRAServer jiraServer;
    private URI hostURI;
    private HttpHost target;

    public JiraIssueCreationRestClient(JIRAServer jiraServer) {
        this.jiraServer = jiraServer;
        try {
            this.hostURI = new URI(jiraServer.getURL());
        }
        catch (URISyntaxException e) {
            throw new JiraIssueCreationException("Could not parse the Jira Server URL.", e);
        }
        this.target = new HttpHost(this.hostURI.getScheme(), this.hostURI.getHost(), this.hostURI.getPort());
    }

    private HttpClientContext getLocalContext(HttpUriRequestBase request) {
        ContextBuilder builder = ContextBuilder.create();
        this.jiraServer.getJiraAuthenticator().ifPresent(a -> a.authenticateInHttpClient(builder, (HttpUriRequest)request, this.target));
        return builder.build();
    }

    private CloseableHttpClient getHttpClient() {
        return HttpClients.createDefault();
    }

    public String getProjects() {
        URI projectURI = this.hostURI.resolve("/rest/api/2/project");
        return this.get(projectURI);
    }

    public String getIssueTypes(String project) {
        URI issueTypesURI = this.hostURI.resolve("/rest/api/2/issue/createmeta/" + JiraIssueCreationRestClient.urlEncode(project) + "/issuetypes");
        return this.paginatedGet(issueTypesURI);
    }

    public String getFieldsMetadata(String project, String issueType) {
        URI fieldsMetadataURI = this.hostURI.resolve("/rest/api/2/issue/createmeta/" + JiraIssueCreationRestClient.urlEncode(project) + "/issuetypes/" + JiraIssueCreationRestClient.urlEncode(issueType));
        return this.paginatedGet(fieldsMetadataURI);
    }

    public String getAssignableUsers(String project, String text) {
        URI assignableUsersURI = this.hostURI.resolve("/rest/api/2/user/assignable/search?project=" + JiraIssueCreationRestClient.urlEncode(project) + "&username=" + JiraIssueCreationRestClient.urlEncode(text));
        return this.get(assignableUsersURI);
    }

    public String getUsers(String text) {
        URI usersURI = this.hostURI.resolve("/rest/api/2/user/search?username=" + JiraIssueCreationRestClient.urlEncode(text));
        return this.get(usersURI);
    }

    public String getUser(String text) {
        URI userURI = this.hostURI.resolve("/rest/api/2/user?username=" + JiraIssueCreationRestClient.urlEncode(text));
        return this.get(userURI);
    }

    public String postIssue(String inputData) {
        URI createIssueURI = this.hostURI.resolve("/rest/api/2/issue");
        return this.post(createIssueURI, inputData);
    }

    public String paginatedGet(URI uri) {
        int total = 0;
        boolean isLast = false;
        ArrayList entries = new ArrayList();
        while (!isLast) {
            URI paginationURI = JiraIssueCreationRestClient.formatPaginationParameters(entries.size(), uri);
            String rawResponse = this.get(paginationURI);
            JsonNode response = JiraIssueCreationRestClient.asTree(rawResponse);
            if (response.has(TOTAL)) {
                total = response.get(TOTAL).asInt();
            }
            if (!response.has(IS_LAST)) {
                throw new JiraIssueCreationException("Expected a paginated response.");
            }
            isLast = response.get(IS_LAST).asBoolean();
            if (response.has(VALUES)) {
                response.get(VALUES).forEach(entry -> entries.add(entry));
                continue;
            }
            throw new JiraIssueCreationException("Expected a paginated response.");
        }
        return JiraIssueCreationRestClient.asJSON(Map.of(START_AT, 0, MAX_RESULTS, entries.size(), TOTAL, total, IS_LAST, isLast, VALUES, entries));
    }

    private static URI formatPaginationParameters(int start, URI baseURI) {
        String baseURIString = baseURI.toString();
        String baseURIQueryString = baseURI.getQuery();
        boolean extraParam = baseURIQueryString != null && !baseURIQueryString.isBlank();
        try {
            return new URI(baseURIString + (extraParam ? (char)'&' : '?') + "startAt=" + JiraIssueCreationRestClient.urlEncode(Integer.toString(start)));
        }
        catch (URISyntaxException e) {
            throw new JiraIssueCreationException("Failed to format pagination parameters.", e);
        }
    }

    private String get(URI uri) {
        CloseableHttpClient client = this.getHttpClient();
        try {
            HttpGet httpget = new HttpGet(uri);
            httpget.setHeader("Content-Type", (Object)APPLICATION_JSON);
            try {
                String string = ((String)client.execute(this.target, (ClassicHttpRequest)httpget, (HttpContext)this.getLocalContext((HttpUriRequestBase)httpget), response -> EntityUtils.toString((HttpEntity)response.getEntity()))).toString();
                return string;
            }
            catch (IOException e) {
                throw new JiraIssueCreationException("Failed to perform a GET Request.", e);
            }
        }
        finally {
            try {
                client.close();
            }
            catch (IOException e) {
                throw new JiraIssueCreationException(CLIENT_CLOSE_FAILURE, e);
            }
        }
    }

    private String post(URI uri, String data) {
        CloseableHttpClient client = this.getHttpClient();
        try {
            HttpPost httppost = new HttpPost(uri);
            httppost.setEntity((HttpEntity)new StringEntity(data));
            httppost.setHeader("Content-Type", (Object)APPLICATION_JSON);
            httppost.setHeader("Accept", (Object)APPLICATION_JSON);
            try {
                String string = ((String)client.execute(this.target, (ClassicHttpRequest)httppost, (HttpContext)this.getLocalContext((HttpUriRequestBase)httppost), response -> EntityUtils.toString((HttpEntity)response.getEntity()))).toString();
                return string;
            }
            catch (IOException e) {
                throw new JiraIssueCreationException("Failed to perform a POST Request.", e);
            }
        }
        finally {
            try {
                client.close();
            }
            catch (IOException e) {
                throw new JiraIssueCreationException(CLIENT_CLOSE_FAILURE, e);
            }
        }
    }

    private static String urlEncode(String input) {
        return URLEncoder.encode(input, StandardCharsets.UTF_8);
    }

    private static String asJSON(Object object) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new JiraIssueCreationException("Failed to serialize an object as JSON.", e);
        }
    }

    private static JsonNode asTree(String json) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            throw new JiraIssueCreationException("Failed to parse JSON.", e);
        }
    }
}

