/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.jirapro.issuecreate.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.web.XWikiRequest;
import com.xwiki.jirapro.issuecreate.internal.JiraIssueCreationException;
import com.xwiki.jirapro.issuecreate.internal.JiraIssueCreationManager;
import com.xwiki.jirapro.issuecreate.internal.JiraIssueCreationRestClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.ServletInputStream;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.jira.config.JIRAAuthenticator;
import org.xwiki.contrib.jira.config.JIRAConfiguration;
import org.xwiki.contrib.jira.config.JIRAServer;
import org.xwiki.contrib.jira.config.internal.BasicAuthJIRAAuthenticator;
import org.xwiki.text.StringUtils;

@Component
@Singleton
public class DefaultJiraIssueCreationManager
implements JiraIssueCreationManager {
    private static final String LABEL = "label";
    private static final String VALUE = "value";
    private static final String HINT = "hint";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String SUBTASK = "subtask";
    private static final String REPORTER = "reporter";
    private static final String AVATAR_URLS = "avatarUrls";
    private static final String ICON = "icon";
    private static final String URL = "url";
    private static final String ISSUE_TYPE = "issuetype";
    private static final String PROJECT = "project";
    private static final String ID = "id";
    private static final String KEY = "key";
    private static final String VALUES = "values";
    @Inject
    private JIRAConfiguration jiraConfiguration;
    @Inject
    private Logger logger;
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    @Override
    public String suggestInstance() {
        ArrayList res = new ArrayList();
        for (Map.Entry entry : this.jiraConfiguration.getJIRAServers().entrySet()) {
            TreeMap<String, String> resEntry = new TreeMap<String, String>();
            resEntry.put(LABEL, (String)entry.getKey());
            resEntry.put(VALUE, (String)entry.getKey());
            resEntry.put(HINT, ((JIRAServer)entry.getValue()).getURL());
            res.add(resEntry);
        }
        return DefaultJiraIssueCreationManager.asJSON(res);
    }

    @Override
    public String getAuthenticatorID(String instanceId) {
        JIRAServer jiraServer = (JIRAServer)this.jiraConfiguration.getJIRAServers().get(instanceId);
        Optional optionalAuthenticator = jiraServer.getJiraAuthenticator();
        if (optionalAuthenticator.isPresent()) {
            JIRAAuthenticator authenticator = (JIRAAuthenticator)optionalAuthenticator.get();
            return authenticator.getClass().getName();
        }
        return "";
    }

    @Override
    public String suggestProject(String instanceId, String text) {
        String lowercaseText = text.toLowerCase();
        ArrayList res = new ArrayList();
        JsonNode jsonTree = DefaultJiraIssueCreationManager.asTree(this.getJiraIssueCreationRestClient(instanceId).getProjects());
        if (!jsonTree.isArray()) {
            throw new JiraIssueCreationException("Expected a JSON array in Jira response.");
        }
        for (JsonNode projectJSON : jsonTree) {
            Iterator iterator;
            if (res.size() > 5) break;
            TreeMap<String, Object> resEntry = new TreeMap<String, Object>();
            String name = projectJSON.get(NAME).asText();
            String key = projectJSON.get(KEY).asText();
            if (!name.toLowerCase().contains(lowercaseText) && !key.toLowerCase().contains(lowercaseText)) continue;
            try {
                this.getJiraIssueCreationRestClient(instanceId).getIssueTypes(key);
            }
            catch (JiraIssueCreationException e) {
                continue;
            }
            String iconURL = null;
            JsonNode avatarUrls = projectJSON.get(AVATAR_URLS);
            if (avatarUrls != null && (iterator = avatarUrls.iterator()).hasNext()) {
                JsonNode iconJSON = (JsonNode)iterator.next();
                iconURL = iconJSON.asText();
            }
            resEntry.put(LABEL, name + " (" + key + ")");
            resEntry.put(VALUE, key);
            if (iconURL != null) {
                resEntry.put(ICON, Collections.singletonMap(URL, iconURL));
            }
            res.add(resEntry);
        }
        return DefaultJiraIssueCreationManager.asJSON(res);
    }

    @Override
    public String suggestIssueType(String instanceId, String project, String text) {
        JsonNode jsonTree = DefaultJiraIssueCreationManager.asTree(this.getJiraIssueCreationRestClient(instanceId).getIssueTypes(project));
        JsonNode valuesTree = jsonTree.get(VALUES);
        if (valuesTree == null) {
            throw new JiraIssueCreationException("Invalid issuetypes JSON: could not find the 'values' attribute.");
        }
        if (!valuesTree.isArray()) {
            throw new JiraIssueCreationException("Invalid issuetypes JSON: 'values' attribute is not an array.");
        }
        ArrayList res = new ArrayList();
        for (JsonNode issueTypeJSON : valuesTree) {
            TreeMap<String, Object> resEntry = new TreeMap<String, Object>();
            String name = issueTypeJSON.get(NAME).asText();
            String description = issueTypeJSON.get(DESCRIPTION).asText();
            Integer id = issueTypeJSON.get(ID).asInt();
            Boolean subtask = issueTypeJSON.get(SUBTASK).asBoolean();
            if (subtask.booleanValue()) continue;
            String iconURL = issueTypeJSON.get("iconUrl").asText();
            resEntry.put(LABEL, name);
            if (description != null) {
                resEntry.put(HINT, description);
            }
            resEntry.put(VALUE, id);
            if (iconURL != null) {
                resEntry.put(ICON, Collections.singletonMap(URL, iconURL));
            }
            res.add(resEntry);
        }
        return DefaultJiraIssueCreationManager.asJSON(res);
    }

    @Override
    public String suggestAssignableUser(String instanceId, String project, String text) {
        JsonNode jsonTree = DefaultJiraIssueCreationManager.asTree(this.getJiraIssueCreationRestClient(instanceId).getAssignableUsers(project, text));
        return this.suggestUser(jsonTree);
    }

    @Override
    public String suggestUser(String instanceId, String text) {
        JsonNode jsonTree = DefaultJiraIssueCreationManager.asTree(this.getJiraIssueCreationRestClient(instanceId).getUsers(text));
        return this.suggestUser(jsonTree);
    }

    private String suggestUser(JsonNode jsonTree) {
        ArrayList res = new ArrayList();
        for (JsonNode usersJSON : jsonTree) {
            Iterator iterator;
            if (res.size() > 20) break;
            TreeMap<String, Object> resEntry = new TreeMap<String, Object>();
            String name = usersJSON.get(NAME).asText();
            String displayName = usersJSON.get("displayName").asText();
            String emailAddress = usersJSON.get("emailAddress").asText();
            String iconURL = null;
            JsonNode avatarUrls = usersJSON.get(AVATAR_URLS);
            if (avatarUrls != null && (iterator = avatarUrls.iterator()).hasNext()) {
                JsonNode iconJSON = (JsonNode)iterator.next();
                iconURL = iconJSON.asText();
            }
            String formattedName = displayName + " - " + emailAddress + " (" + name + ")";
            resEntry.put(LABEL, formattedName);
            resEntry.put(VALUE, name);
            if (iconURL != null) {
                resEntry.put(ICON, Collections.singletonMap(URL, iconURL));
            }
            res.add(resEntry);
        }
        return DefaultJiraIssueCreationManager.asJSON(res);
    }

    @Override
    public String getFieldsMetadata(String instanceId, String project, String issueType) {
        return this.getJiraIssueCreationRestClient(instanceId).getFieldsMetadata(project, issueType);
    }

    @Override
    public String createIssue(String instanceId, String inputData) {
        JsonNode inputTree;
        JsonNode fieldsTree;
        String inputJsonText = inputData;
        if (StringUtils.isEmpty((CharSequence)inputData)) {
            ServletInputStream inputStream;
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            XWikiRequest request = xcontext.getRequest();
            try {
                inputStream = request.getInputStream();
            }
            catch (IOException e) {
                throw new JiraIssueCreationException("Could not retrieve POST data.", e);
            }
            BufferedReader bufferReader = new BufferedReader(new InputStreamReader((InputStream)inputStream));
            StringBuilder stringBuilder = new StringBuilder();
            bufferReader.lines().forEach(line -> stringBuilder.append((String)line));
            inputJsonText = stringBuilder.toString();
        }
        if ((fieldsTree = (inputTree = DefaultJiraIssueCreationManager.asTree(inputJsonText)).get("fields")) == null) {
            throw new JiraIssueCreationException("Invalid Input Data.");
        }
        JsonNode issueTypeTree = fieldsTree.get(ISSUE_TYPE);
        JsonNode projectTree = fieldsTree.get(PROJECT);
        JsonNode reporterTree = fieldsTree.get(REPORTER);
        if (issueTypeTree == null) {
            throw new JiraIssueCreationException("Missing issuetype field.");
        }
        if (projectTree == null) {
            throw new JiraIssueCreationException("Missing project field.");
        }
        if (reporterTree != null) {
            throw new JiraIssueCreationException("Unexpected reporter field.");
        }
        JsonNode issueTypeIdTree = issueTypeTree.get(ID);
        JsonNode projectKeyTree = projectTree.get(KEY);
        if (issueTypeIdTree == null || !issueTypeIdTree.isTextual()) {
            throw new JiraIssueCreationException("Invalid issueType field.");
        }
        if (projectKeyTree == null || !projectKeyTree.isTextual()) {
            throw new JiraIssueCreationException("Invalid project field.");
        }
        String issueType = issueTypeIdTree.asText();
        String project = projectKeyTree.asText();
        ObjectNode fields = (ObjectNode)fieldsTree;
        if (this.isReporterNeeded(instanceId, project, issueType)) {
            JsonNode reporterField = DefaultJiraIssueCreationManager.asTree(DefaultJiraIssueCreationManager.asJSON(Collections.singletonMap(NAME, this.getReporterUserName(instanceId))));
            fields.set(REPORTER, reporterField);
        }
        return this.getJiraIssueCreationRestClient(instanceId).postIssue(DefaultJiraIssueCreationManager.asJSON(inputTree));
    }

    private boolean isReporterNeeded(String instanceId, String project, String issueType) {
        if (this.getReporterUserName(instanceId) == null) {
            return false;
        }
        JsonNode fieldsMetadataTree = DefaultJiraIssueCreationManager.asTree(this.getFieldsMetadata(instanceId, project, issueType));
        if (fieldsMetadataTree == null) {
            throw new JiraIssueCreationException("Invalid fieldsMetadata JSON.");
        }
        JsonNode valuesTree = fieldsMetadataTree.get(VALUES);
        if (valuesTree == null) {
            throw new JiraIssueCreationException("Invalid fieldsMetadata JSON: could not find the 'values' attribute.");
        }
        if (!valuesTree.isArray()) {
            throw new JiraIssueCreationException("Invalid fieldsMetadata JSON: 'values' attribute is not an array.");
        }
        JsonNode[] reporterFieldTree = new JsonNode[]{null};
        valuesTree.forEach(field -> {
            JsonNode fieldIdTree = field.get("fieldId");
            if (fieldIdTree == null || !fieldIdTree.isTextual()) {
                return;
            }
            if (fieldIdTree.asText().equals(REPORTER)) {
                reporterFieldTree[0] = field;
            }
        });
        return reporterFieldTree[0] != null;
    }

    private String getReporterUserName(String instanceId) {
        JIRAServer jiraServer = (JIRAServer)this.jiraConfiguration.getJIRAServers().get(instanceId);
        Optional authenticator = jiraServer.getJiraAuthenticator();
        if (authenticator.isPresent() && authenticator.get() instanceof BasicAuthJIRAAuthenticator) {
            String userName = ((XWikiContext)this.xcontextProvider.get()).getUserReference().getName();
            String jiraResponse = this.getJiraIssueCreationRestClient(instanceId).getUser(userName);
            JsonNode jiraUser = DefaultJiraIssueCreationManager.asTree(jiraResponse);
            if (jiraUser.has(NAME)) {
                return jiraUser.get(NAME).asText();
            }
        }
        return null;
    }

    private static String asJSON(Object object) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new JiraIssueCreationException("Failed to serialize an object as JSON.", e);
        }
    }

    private static JsonNode asTree(String json) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            throw new JiraIssueCreationException("Failed to parse JSON.", e);
        }
    }

    private JiraIssueCreationRestClient getJiraIssueCreationRestClient(String instanceId) {
        return new JiraIssueCreationRestClient((JIRAServer)this.jiraConfiguration.getJIRAServers().get(instanceId));
    }
}

