/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.flashmessages.test.po;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.Select;
import org.xwiki.flashmessages.test.po.FlashEntryViewPage;
import org.xwiki.flashmessages.test.po.FlashHomePage;
import org.xwiki.flashmessages.test.po.FlashPage;
import org.xwiki.test.ui.po.SuggestInputElement;
import org.xwiki.test.ui.po.editor.BootstrapDateTimePicker;

public class FlashEntryEditPage
extends FlashPage {
    @FindBy(id="Flash.FlashClass_0_dateBegin")
    private WebElement dateBeginElement;
    @FindBy(id="Flash.FlashClass_0_dateEnd")
    private WebElement dateEndElement;
    @FindBy(id="Flash.FlashClass_0_repeat")
    private WebElement repeatElement;
    @FindBy(xpath="//label[@for='Flash.FlashClass_0_repeatInterval']")
    private WebElement repeatIntervalLabelElement;
    @FindBy(id="Flash.FlashClass_0_repeatInterval")
    private WebElement repeatIntervalElement;
    @FindBy(xpath="//label[@for='Flash.FlashClass_0_repeatFrequency']")
    private WebElement repeatFrequencyLabelElement;
    @FindBy(id="Flash.FlashClass_0_repeatFrequency")
    private WebElement repeatFrequencyElement;
    @FindBy(xpath="//label[@for='Flash.FlashClass_0_repeatDays']")
    private WebElement repeatDaysLabelElement;
    @FindBy(name="Flash.FlashClass_0_repeatDays")
    private List<WebElement> repeatDaysElements;
    @FindBy(xpath="//label[@for='repeatSummary']")
    private WebElement repeatSummaryLabelElement;
    @FindBy(id="repeatSummary")
    private WebElement repeatSummaryElement;
    @FindBy(id="Flash.FlashClass_0_groups")
    protected WebElement groupsElement;
    @FindBy(id="Flash.FlashClass_0_wikiScope")
    protected WebElement wikiScopeElement;
    @FindBy(id="Flash.FlashClass_0_message")
    protected WebElement messageElement;
    @FindBy(name="action_save")
    private WebElement saveAndViewButtonElement;
    @FindBy(name="action_cancel")
    private WebElement cancelButtonElement;

    public static FlashEntryEditPage gotoPage(String page) {
        return FlashEntryEditPage.gotoPage(page, "en");
    }

    public static FlashEntryEditPage gotoPage(String page, String language) {
        FlashEntryEditPage.getUtil().gotoPage(FlashHomePage.getSpace(), page, "edit", "language=" + language);
        return new FlashEntryEditPage();
    }

    private void setDate(WebElement element, Calendar calendar) {
        this.messageElement.click();
        element.click();
        BootstrapDateTimePicker datePicker = new BootstrapDateTimePicker();
        datePicker.changeMonthAndYear().changeYear().selectYear(this.getFormattedDate(calendar, "yyyy")).selectMonth(this.getFormattedDate(calendar, "MMM")).selectDay(this.getFormattedDate(calendar, "d"));
        int minutes = Integer.parseInt(this.getFormattedDate(calendar, "m"));
        datePicker.toggleTimePicker().changeHour().selectHour(this.getFormattedDate(calendar, "HH")).changeMinute().selectMinute(String.format("%02d", minutes - minutes % 5));
        for (int i = 0; i < minutes % 5; ++i) {
            datePicker.incrementMinute();
        }
        datePicker.toggleTimePicker().close();
    }

    private String getFormattedDate(Calendar calendar, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(calendar.getTime());
    }

    public void setDateBegin(Calendar dateBegin) {
        this.setDate(this.dateBeginElement, dateBegin);
    }

    public void setDateEnd(Calendar dateEnd) {
        this.setDate(this.dateEndElement, dateEnd);
    }

    public void setRepeat(Boolean repeat) {
        Select statusSelect = new Select(this.repeatElement);
        statusSelect.selectByValue(repeat != false ? "1" : "0");
    }

    public String getRepeatIntervalLabel() {
        return this.repeatIntervalLabelElement.getText();
    }

    public List<String> getRepeatInterval() {
        LinkedList<String> repeatInterval = new LinkedList<String>();
        List options = this.repeatIntervalElement.findElements(By.tagName((String)"option"));
        for (WebElement option : options) {
            repeatInterval.add(option.getAttribute("label"));
        }
        return repeatInterval;
    }

    public void setRepeatInterval(String interval) {
        Select statusSelect = new Select(this.repeatIntervalElement);
        statusSelect.selectByValue(interval);
    }

    public String getRepeatFrequencyLabel() {
        return this.repeatFrequencyLabelElement.getText();
    }

    public void setRepeatFrequency(int frequency) {
        Select statusSelect = new Select(this.repeatFrequencyElement);
        statusSelect.selectByValue(Integer.toString(frequency));
    }

    public String getRepeatDaysLabel() {
        return this.repeatDaysLabelElement.getText();
    }

    public List<String> getRepeatDays() {
        LinkedList<String> repeatDays = new LinkedList<String>();
        for (int i = 0; i < 7; ++i) {
            repeatDays.add(this.getDriver().findElementWithoutWaiting(By.xpath((String)("//label[@for='xwiki-form-repeatDays-0-" + i + "']"))).getText());
        }
        return repeatDays;
    }

    public void setRepeatDays(List<String> days) {
        List<String> daysOfTheWeek = Arrays.asList("monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday");
        for (int i = 0; i < daysOfTheWeek.size(); ++i) {
            WebElement checkbox = this.getDriver().findElementWithoutWaiting(By.id((String)("xwiki-form-repeatDays-0-" + i)));
            if (!checkbox.isDisplayed() || checkbox.isSelected() == days.contains(daysOfTheWeek.get(i))) continue;
            checkbox.click();
        }
    }

    public String getRepeatSummaryLabel() {
        return this.repeatSummaryLabelElement.getText();
    }

    public void setGroups(List<String> groups) {
        SuggestInputElement groupSuggest = new SuggestInputElement(this.groupsElement);
        groupSuggest.clearSelectedSuggestions();
        for (String group : groups) {
            groupSuggest.sendKeys(new CharSequence[]{group}).waitForSuggestions().selectByVisibleText(group);
        }
        groupSuggest.hideSuggestions();
    }

    public void setWikiScope(String wikiScope) {
        Select wikiScopeSelect = new Select(this.wikiScopeElement);
        wikiScopeSelect.selectByValue(wikiScope);
    }

    public void setMessage(String message) {
        this.messageElement.clear();
        this.messageElement.sendKeys(new CharSequence[]{message});
    }

    public FlashEntryViewPage clickSaveAndView() {
        this.getDriver().addPageNotYetReloadedMarker();
        this.saveAndViewButtonElement.click();
        this.getDriver().waitUntilPageIsReloaded();
        return new FlashEntryViewPage();
    }

    public FlashEntryViewPage clickCancel() {
        this.cancelButtonElement.click();
        return new FlashEntryViewPage();
    }
}

