/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filemanager.script;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.filemanager.Path;
import org.xwiki.filemanager.internal.reference.DocumentNameSequence;
import org.xwiki.filemanager.job.BatchPathRequest;
import org.xwiki.filemanager.job.FileManager;
import org.xwiki.filemanager.reference.UniqueDocumentReferenceGenerator;
import org.xwiki.job.JobException;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="drive")
@Singleton
public class DriveScriptService
implements ScriptService {
    private static final String ERROR_KEY = "scriptservice.drive.error";
    private static final Pattern PATH_PATTERN = Pattern.compile("/");
    @Inject
    private FileManager fileManager;
    @Inject
    private Execution execution;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private UniqueDocumentReferenceGenerator uniqueDocRefGenerator;

    public String move(Collection<String> paths, String destination) {
        this.setError(null);
        try {
            return this.fileManager.move(this.asPath(paths), this.asPath(destination));
        }
        catch (JobException e) {
            this.setError((Exception)((Object)e));
            return null;
        }
    }

    public String copy(Collection<String> paths, String destination) {
        this.setError(null);
        try {
            return this.fileManager.copy(this.asPath(paths), this.asPath(destination));
        }
        catch (JobException e) {
            this.setError((Exception)((Object)e));
            return null;
        }
    }

    public String delete(Collection<String> paths) {
        this.setError(null);
        try {
            return this.fileManager.delete(this.asPath(paths));
        }
        catch (JobException e) {
            this.setError((Exception)((Object)e));
            return null;
        }
    }

    public String pack(Collection<String> paths, AttachmentReference outputFileReference) {
        this.setError(null);
        try {
            return this.fileManager.pack(this.asPath(paths), outputFileReference);
        }
        catch (JobException e) {
            this.setError((Exception)((Object)e));
            return null;
        }
    }

    public JobStatus getJobStatus(String jobId) {
        return this.fileManager.getJobStatus(jobId);
    }

    public List<String> getActiveJobs() {
        ArrayList<String> activeJobs = new ArrayList<String>();
        for (String jobId : this.fileManager.getActiveJobs()) {
            if (!this.jobTargetsDrive(jobId)) continue;
            activeJobs.add(jobId);
        }
        return activeJobs;
    }

    public DocumentReference getUniqueReference(String name) {
        return this.uniqueDocRefGenerator.generate(this.getCurrentDriveReference(), new DocumentNameSequence(name));
    }

    public Exception getLastError() {
        return (Exception)this.execution.getContext().getProperty(ERROR_KEY);
    }

    private void setError(Exception e) {
        this.execution.getContext().setProperty(ERROR_KEY, (Object)e);
    }

    private SpaceReference getCurrentDriveReference() {
        return this.documentAccessBridge.getCurrentDocumentReference().getLastSpaceReference();
    }

    private Path asPath(String serializedPath) {
        String childId;
        DocumentReference parentReference = null;
        DocumentReference childReference = null;
        String[] pathElements = PATH_PATTERN.split(serializedPath, 2);
        String parentId = pathElements[0];
        if (!StringUtils.isEmpty((CharSequence)parentId)) {
            parentReference = new DocumentReference(parentId, this.getCurrentDriveReference());
        }
        if (pathElements.length > 1 && !StringUtils.isEmpty((CharSequence)(childId = pathElements[1]))) {
            childReference = new DocumentReference(childId, this.getCurrentDriveReference());
        }
        return new Path(parentReference, childReference);
    }

    private Collection<Path> asPath(Collection<String> serializedPaths) {
        LinkedList<Path> paths = new LinkedList<Path>();
        for (String serializedPath : serializedPaths) {
            paths.add(this.asPath(serializedPath));
        }
        return paths;
    }

    private boolean jobTargetsDrive(String jobId) {
        Collection<Path> paths;
        JobStatus jobStatus = this.getJobStatus(jobId);
        SpaceReference currentDriveReference = this.getCurrentDriveReference();
        if (jobStatus != null && (paths = ((BatchPathRequest)jobStatus.getRequest()).getPaths()) != null && paths.size() > 0) {
            Path firstPath = paths.iterator().next();
            DocumentReference reference = firstPath.getFileReference() != null ? firstPath.getFileReference() : firstPath.getFolderReference();
            return reference != null && reference.getLastSpaceReference().equals((Object)currentDriveReference);
        }
        return false;
    }
}

