/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filemanager.internal.reference;

import java.util.Iterator;
import java.util.UUID;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class DocumentNameSequence
implements Iterator<String> {
    private final String base;
    private int consecutiveCounter;
    private int randomCounter;

    public DocumentNameSequence(String base) {
        this.base = base;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public String next() {
        Object name = this.base;
        if (this.consecutiveCounter == 0) {
            ++this.consecutiveCounter;
        } else if (this.consecutiveCounter < 100) {
            name = (String)name + this.consecutiveCounter++;
        } else if (this.randomCounter < 5) {
            name = (String)name + (100 + (int)(Math.random() * 100000.0));
            ++this.randomCounter;
        } else {
            name = (String)name + String.valueOf(UUID.randomUUID());
        }
        return name;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 7).append((Object)this.base).toHashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        DocumentNameSequence other = (DocumentNameSequence)object;
        return new EqualsBuilder().append((Object)this.base, (Object)other.base).isEquals();
    }
}

