/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filemanager.internal.reference;

import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.eviction.LRUEvictionConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.manager.NamespacedComponentManager;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.filemanager.reference.UniqueDocumentReferenceGenerator;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.validation.EntityNameValidationConfiguration;
import org.xwiki.model.validation.EntityNameValidationManager;

@Component
@Singleton
public class DefaultUniqueDocumentReferenceGenerator
implements UniqueDocumentReferenceGenerator,
Initializable,
Disposable {
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private CacheManager cacheManager;
    @Inject
    private EntityNameValidationManager entityNameValidationManager;
    @Inject
    private EntityNameValidationConfiguration entityNameValidationConfiguration;
    private Cache<Boolean> documentReferenceCache;
    @Inject
    private ComponentManager componentManager;

    private String transformName(String name) {
        if (this.entityNameValidationConfiguration != null && this.entityNameValidationConfiguration.useTransformation() && this.entityNameValidationManager.getEntityReferenceNameStrategy() != null) {
            return this.entityNameValidationManager.getEntityReferenceNameStrategy().transform(name);
        }
        return name;
    }

    @Override
    public synchronized DocumentReference generate(SpaceReference spaceReference, Iterator<String> documentNameSequence) {
        while (documentNameSequence.hasNext()) {
            String name = this.transformName(documentNameSequence.next());
            DocumentReference reference = new DocumentReference(name, spaceReference);
            String key = reference.toString();
            if (this.documentReferenceCache.get(key) != null) continue;
            this.documentReferenceCache.set(key, (Object)true);
            try {
                if (this.documentAccessBridge.exists(reference)) continue;
                return reference;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public void initialize() throws InitializationException {
        String namespace;
        CacheConfiguration cacheConfiguration = new CacheConfiguration();
        Object uniqueDocumentReference = "unique.documentReference";
        if (this.componentManager instanceof NamespacedComponentManager && (namespace = ((NamespacedComponentManager)this.componentManager).getNamespace()) != null) {
            uniqueDocumentReference = (String)uniqueDocumentReference + "." + namespace;
        }
        cacheConfiguration.setConfigurationId((String)uniqueDocumentReference);
        LRUEvictionConfiguration lru = new LRUEvictionConfiguration();
        lru.setMaxEntries(1000);
        lru.setTimeToLive(3600);
        cacheConfiguration.put((Object)"eviction", (Object)lru);
        try {
            this.documentReferenceCache = this.cacheManager.createNewCache(cacheConfiguration);
        }
        catch (CacheException e) {
            throw new InitializationException("Failed to initialize the document reference cache.", (Throwable)e);
        }
    }

    public void dispose() throws ComponentLifecycleException {
        if (this.documentReferenceCache != null) {
            this.documentReferenceCache.dispose();
        }
    }
}

