/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filemanager.internal.job;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.filemanager.File;
import org.xwiki.filemanager.FileSystem;
import org.xwiki.filemanager.Folder;
import org.xwiki.filemanager.Path;
import org.xwiki.filemanager.job.PackJobStatus;
import org.xwiki.filemanager.job.PackRequest;
import org.xwiki.job.AbstractJob;
import org.xwiki.job.Job;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceSerializer;
import org.xwiki.resource.temporary.TemporaryResourceReference;
import org.xwiki.resource.temporary.TemporaryResourceStore;
import org.xwiki.url.ExtendedURL;

@Component
@Named(value="fileManager/pack")
public class PackJob
extends AbstractJob<PackRequest, PackJobStatus> {
    public static final String JOB_TYPE = "fileManager/pack";
    private static final String MODULE_NAME = "filemanager";
    @Inject
    private TemporaryResourceStore temporaryResourceStore;
    @Inject
    @Named(value="standard/tmp")
    private ResourceReferenceSerializer<TemporaryResourceReference, ExtendedURL> urlTemporaryResourceReferenceSerializer;
    @Inject
    private FileSystem fileSystem;

    public String getType() {
        return JOB_TYPE;
    }

    protected PackJobStatus createNewStatus(PackRequest request) {
        Job currentJob = this.jobContext.getCurrentJob();
        JobStatus currentJobStatus = currentJob != null ? currentJob.getStatus() : null;
        return new PackJobStatus(this.getType(), request, currentJobStatus, this.observationManager, this.loggerManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInternal() throws Exception {
        Collection<Path> paths = ((PackRequest)this.getRequest()).getPaths();
        if (paths == null) {
            return;
        }
        AttachmentReference outputFileReference = ((PackRequest)this.getRequest()).getOutputFileReference();
        TemporaryResourceReference temporaryResourceReference = new TemporaryResourceReference(MODULE_NAME, Collections.singletonList(outputFileReference.getName()), outputFileReference.getParent());
        temporaryResourceReference.addParameter("jobId", (Object)StringUtils.join((Iterable)((PackRequest)this.request).getId(), (String)"/"));
        java.io.File outputFile = this.temporaryResourceStore.createTemporaryFile(temporaryResourceReference, (InputStream)new ByteArrayInputStream(new byte[0]));
        String pathPrefix = "";
        this.progressManager.pushLevelProgress(paths.size(), (Object)this);
        try (ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(outputFile));){
            for (Path path : paths) {
                this.progressManager.startStep((Object)this);
                this.pack(path, zip, pathPrefix);
                this.progressManager.endStep((Object)this);
            }
        }
        finally {
            ((PackJobStatus)this.getStatus()).setOutputFileSize(outputFile.length());
            ((PackJobStatus)this.getStatus()).setDownloadURL(((ExtendedURL)this.urlTemporaryResourceReferenceSerializer.serialize((ResourceReference)temporaryResourceReference)).serialize());
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    private void pack(Path path, ZipOutputStream zip, String pathPrefix) {
        if (path.getFileReference() != null) {
            this.packFile(path.getFileReference(), zip, pathPrefix);
        } else if (path.getFolderReference() != null) {
            this.packFolder(path.getFolderReference(), zip, pathPrefix);
        }
    }

    private void packFile(DocumentReference fileReference, ZipOutputStream zip, String pathPrefix) {
        File file = this.fileSystem.getFile(fileReference);
        if (file != null && this.fileSystem.canView(fileReference)) {
            try {
                String path = pathPrefix + file.getName();
                this.logger.info("Packing file [{}]", (Object)path);
                zip.putNextEntry((ZipEntry)new ZipArchiveEntry(path));
                long bytesWritten = IOUtils.copyLarge((InputStream)file.getContent(), (OutputStream)zip);
                zip.closeEntry();
                ((PackJobStatus)this.getStatus()).setBytesWritten(((PackJobStatus)this.getStatus()).getBytesWritten() + bytesWritten);
            }
            catch (IOException e) {
                this.logger.warn("Failed to pack file [{}].", (Object)fileReference, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packFolder(DocumentReference folderReference, ZipOutputStream zip, String pathPrefix) {
        Folder folder = this.fileSystem.getFolder(folderReference);
        if (folder != null && this.fileSystem.canView(folderReference)) {
            List<DocumentReference> childFolderReferences = folder.getChildFolderReferences();
            List<DocumentReference> childFileReferences = folder.getChildFileReferences();
            this.progressManager.pushLevelProgress(childFolderReferences.size() + childFileReferences.size() + 1, (Object)this);
            try {
                this.progressManager.startStep((Object)this);
                String path = pathPrefix + folder.getName() + "/";
                this.logger.info("Packing folder [{}]", (Object)path);
                zip.putNextEntry(new ZipEntry(path));
                zip.closeEntry();
                this.progressManager.endStep((Object)this);
                for (DocumentReference childFolderReference : childFolderReferences) {
                    this.progressManager.startStep((Object)this);
                    this.packFolder(childFolderReference, zip, path);
                    this.progressManager.endStep((Object)this);
                }
                for (DocumentReference childFileReference : childFileReferences) {
                    this.progressManager.startStep((Object)this);
                    this.packFile(childFileReference, zip, path);
                    this.progressManager.endStep((Object)this);
                }
            }
            catch (IOException e) {
                this.logger.warn("Failed to pack folder [{}].", (Object)folderReference, (Object)e);
            }
            finally {
                this.progressManager.popLevelProgress((Object)this);
            }
        }
    }
}

