/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filemanager.internal.job;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.filemanager.File;
import org.xwiki.filemanager.FileSystem;
import org.xwiki.filemanager.Folder;
import org.xwiki.filemanager.Path;
import org.xwiki.filemanager.internal.reference.DocumentNameSequence;
import org.xwiki.filemanager.job.MoveRequest;
import org.xwiki.filemanager.job.OverwriteQuestion;
import org.xwiki.filemanager.reference.UniqueDocumentReferenceGenerator;
import org.xwiki.job.AbstractJob;
import org.xwiki.job.DefaultJobStatus;
import org.xwiki.model.reference.DocumentReference;

@Component
@Named(value="fileManager/move")
public class MoveJob
extends AbstractJob<MoveRequest, DefaultJobStatus<MoveRequest>> {
    public static final String JOB_TYPE = "fileManager/move";
    private static final String ERROR_DESTINATION_NOT_FOUND = "The destination folder [{}] doesn't exist.";
    @Inject
    protected FileSystem fileSystem;
    @Inject
    private UniqueDocumentReferenceGenerator uniqueDocRefGenerator;
    private Boolean overwriteAll;

    public String getType() {
        return JOB_TYPE;
    }

    protected void runInternal() throws Exception {
        Collection<Path> paths = ((MoveRequest)this.getRequest()).getPaths();
        Path destination = ((MoveRequest)this.getRequest()).getDestination();
        if (paths != null && destination != null) {
            if (destination.getFolderReference() != null && this.fileSystem.exists(destination.getFolderReference()) && destination.getFileReference() == null) {
                this.move(paths, destination.getFolderReference());
            } else if (paths.size() == 1 && destination.getFileReference() != null) {
                this.rename(paths.iterator().next(), destination);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void move(Collection<Path> paths, DocumentReference destination) {
        this.progressManager.pushLevelProgress(paths.size(), (Object)this);
        try {
            for (Path path : paths) {
                this.progressManager.startStep((Object)this);
                this.move(path, destination);
                this.progressManager.endStep((Object)this);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    private void move(Path path, DocumentReference destination) {
        if (path.getFileReference() != null) {
            this.moveFile(path.getFileReference(), path.getFolderReference(), destination);
        } else if (path.getFolderReference() != null) {
            this.moveFolder(path.getFolderReference(), destination);
        }
    }

    private void moveFolder(DocumentReference folderReference, DocumentReference newParentReference) {
        if (this.isDescendantOrSelf(newParentReference, folderReference)) {
            this.logger.error("Cannot move [{}] to a sub-folder of itself.", (Object)folderReference);
            return;
        }
        Folder folder = this.fileSystem.getFolder(folderReference);
        if (folder != null && !Objects.equals(folder.getParentReference(), newParentReference)) {
            if (this.fileSystem.canEdit(folderReference)) {
                Folder newParent = this.fileSystem.getFolder(newParentReference);
                if (newParent != null) {
                    this.moveFolder(folder, newParent);
                } else {
                    this.logger.error(ERROR_DESTINATION_NOT_FOUND, (Object)newParentReference);
                }
            } else {
                this.logger.error("You are not allowed to move the folder [{}].", (Object)folderReference);
            }
        }
    }

    protected boolean isDescendantOrSelf(DocumentReference aliceReference, DocumentReference bobReference) {
        DocumentReference parentReference = aliceReference;
        while (parentReference != null && !parentReference.equals((Object)bobReference)) {
            Folder parent = this.fileSystem.getFolder(parentReference);
            if (parent == null) {
                return false;
            }
            parentReference = parent.getParentReference();
        }
        return parentReference != null;
    }

    private void moveFolder(Folder folder, Folder newParent) {
        Folder child = this.getChildFolderByName(newParent, folder.getName());
        if (child != null) {
            this.mergeFolders(folder, child.getReference());
        } else {
            folder.setParentReference(newParent.getReference());
            this.fileSystem.save(folder);
        }
    }

    protected Folder getChildFolderByName(Folder parent, String name) {
        for (DocumentReference childReference : parent.getChildFolderReferences()) {
            Folder child = this.fileSystem.getFolder(childReference);
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeFolders(Folder source, DocumentReference destination) {
        List<DocumentReference> childFolderReferences = source.getChildFolderReferences();
        List<DocumentReference> childFileReferences = source.getChildFileReferences();
        this.progressManager.pushLevelProgress(childFolderReferences.size() + childFileReferences.size() + 1, (Object)this);
        try {
            for (DocumentReference childReference : childFolderReferences) {
                this.progressManager.startStep((Object)this);
                this.moveFolder(childReference, destination);
                this.progressManager.endStep((Object)this);
            }
            for (DocumentReference childReference : childFileReferences) {
                this.progressManager.startStep((Object)this);
                this.moveFile(childReference, source.getReference(), destination);
                this.progressManager.endStep((Object)this);
            }
            this.progressManager.startStep((Object)this);
            if (source.getChildFolderReferences().isEmpty() && source.getChildFileReferences().isEmpty()) {
                if (this.fileSystem.canDelete(source.getReference())) {
                    this.fileSystem.delete(source.getReference());
                } else {
                    this.logger.error("You are not allowed to delete the folder [{}].", (Object)source.getReference());
                }
            }
            this.progressManager.endStep((Object)this);
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    private void moveFile(DocumentReference fileReference, DocumentReference oldParentReference, DocumentReference newParentReference) {
        File file = this.fileSystem.getFile(fileReference);
        if (file != null && !Objects.equals(oldParentReference, newParentReference)) {
            if (this.fileSystem.canEdit(fileReference)) {
                Folder newParent = this.fileSystem.getFolder(newParentReference);
                if (newParent != null) {
                    this.moveFile(file, oldParentReference, newParent);
                } else {
                    this.logger.error(ERROR_DESTINATION_NOT_FOUND, (Object)newParentReference);
                }
            } else {
                this.logger.error("You are not allowed to move the file [{}].", (Object)fileReference);
            }
        }
    }

    private void moveFile(File file, DocumentReference oldParentReference, Folder newParent) {
        if (!this.prepareOverwrite(file.getName(), newParent, file.getReference())) {
            return;
        }
        Collection<DocumentReference> parentReferences = file.getParentReferences();
        boolean save = parentReferences.remove(oldParentReference);
        if (save |= parentReferences.add(newParent.getReference())) {
            this.fileSystem.save(file);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean prepareOverwrite(String fileName, Folder parentFolder, DocumentReference newFileReference) {
        boolean hasMoreParents;
        File child = this.getChildFileByName(parentFolder, fileName);
        if (child == null) return true;
        boolean bl = hasMoreParents = child.getParentReferences().size() > 1;
        if (hasMoreParents && this.fileSystem.canEdit(child.getReference()) || !hasMoreParents && this.fileSystem.canDelete(child.getReference())) {
            if (!this.shouldOverwrite(newFileReference, child.getReference())) return false;
            this.deleteFile(child, parentFolder.getReference());
            return true;
        } else {
            this.logger.error("You are not allowed to overwrite the file [{}].", (Object)child.getReference());
            return false;
        }
    }

    protected File getChildFileByName(Folder parent, String name) {
        for (DocumentReference childReference : parent.getChildFileReferences()) {
            File child = this.fileSystem.getFile(childReference);
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    protected boolean shouldOverwrite(DocumentReference source, DocumentReference destination) {
        if (((MoveRequest)this.getRequest()).isInteractive() && this.getStatus() != null) {
            if (this.overwriteAll == null) {
                OverwriteQuestion question = new OverwriteQuestion(source, destination);
                try {
                    ((DefaultJobStatus)this.getStatus()).ask((Object)question);
                    if (!question.isAskAgain()) {
                        this.overwriteAll = question.isOverwrite();
                    }
                    return question.isOverwrite();
                }
                catch (InterruptedException e) {
                    this.logger.warn("Overwrite question has been interrupted.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                return this.overwriteAll;
            }
        }
        return false;
    }

    private void deleteFile(File file, DocumentReference parentReference) {
        Collection<DocumentReference> parentReferences = file.getParentReferences();
        parentReferences.remove(parentReference);
        if (parentReferences.isEmpty()) {
            this.fileSystem.delete(file.getReference());
        } else {
            this.fileSystem.save(file);
        }
    }

    private void rename(Path oldPath, Path newPath) {
        if (oldPath != null) {
            if (oldPath.getFileReference() != null) {
                this.renameFile(oldPath, newPath);
            } else if (oldPath.getFolderReference() != null) {
                this.renameFolder(oldPath.getFolderReference(), newPath);
            }
        }
    }

    private void renameFolder(DocumentReference oldReference, Path newPath) {
        Folder folder = this.fileSystem.getFolder(oldReference);
        if (folder != null) {
            if (this.fileSystem.canDelete(oldReference)) {
                DocumentReference newParentReference = newPath.getFolderReference();
                if (newParentReference == null) {
                    newParentReference = folder.getParentReference();
                }
                if (Objects.equals(newParentReference, folder.getParentReference()) && newPath.getFileReference().equals((Object)oldReference)) {
                    return;
                }
                if (newParentReference != null) {
                    this.moveAndRenameFolder(folder, new Path(newParentReference, newPath.getFileReference()));
                } else {
                    this.renameFolder(folder, newPath.getFileReference());
                }
            } else {
                this.logger.error("You are not allowed to rename the folder [{}].", (Object)oldReference);
            }
        }
    }

    private void moveAndRenameFolder(Folder folder, Path newPath) {
        Folder newParent = this.fileSystem.getFolder(newPath.getFolderReference());
        Folder child = this.getChildFolderByName(newParent, newPath.getFileReference().getName());
        if (child == null) {
            if (!newParent.getReference().equals((Object)folder.getParentReference())) {
                folder.setParentReference(newParent.getReference());
                this.fileSystem.save(folder);
            }
            if (!newPath.getFileReference().equals((Object)folder.getReference())) {
                this.renameFolder(folder, newPath.getFileReference());
            }
        } else {
            this.logger.error("A folder with the same name [{}] already exists under [{}]", (Object)newPath.getFileReference().getName(), (Object)newParent.getReference());
        }
    }

    private void renameFolder(Folder folder, DocumentReference newReference) {
        DocumentReference actualNewReference = this.getUniqueReference(newReference);
        if (this.fileSystem.canEdit(actualNewReference)) {
            this.fileSystem.rename(folder.getReference(), actualNewReference);
            Folder newFolder = this.fileSystem.getFolder(actualNewReference);
            newFolder.setName(newReference.getName());
            this.fileSystem.save(newFolder);
            for (DocumentReference childFolderReference : folder.getChildFolderReferences()) {
                Folder childFolder = this.fileSystem.getFolder(childFolderReference);
                childFolder.setParentReference(actualNewReference);
                this.fileSystem.save(childFolder);
            }
            for (DocumentReference childFileReference : folder.getChildFileReferences()) {
                File childFile = this.fileSystem.getFile(childFileReference);
                childFile.getParentReferences().remove(folder.getReference());
                childFile.getParentReferences().add(actualNewReference);
                this.fileSystem.save(childFile);
            }
        } else {
            this.logger.error("You are not allowed to create the folder [{}].", (Object)actualNewReference);
        }
    }

    private void renameFile(Path oldPath, Path newPath) {
        File file = this.fileSystem.getFile(oldPath.getFileReference());
        if (file != null) {
            if (this.fileSystem.canDelete(file.getReference())) {
                this.moveAndRenameFile(file, oldPath.getFolderReference(), newPath);
            } else {
                this.logger.error("You are not allowed to rename the file [{}].", (Object)file.getReference());
            }
        }
    }

    private void moveAndRenameFile(File file, DocumentReference parentReference, Path newPath) {
        if (newPath.getFolderReference() != null && parentReference != null && !newPath.getFolderReference().equals((Object)parentReference)) {
            Collection<DocumentReference> parentReferences = file.getParentReferences();
            boolean save = parentReferences.remove(parentReference);
            if (save |= parentReferences.add(newPath.getFolderReference())) {
                this.fileSystem.save(file);
            }
        }
        if (!file.getReference().equals((Object)newPath.getFileReference())) {
            this.renameFile(file, newPath.getFileReference());
        }
    }

    private void renameFile(File file, DocumentReference newReference) {
        DocumentReference actualNewReference;
        if (!file.getName().equals(newReference.getName())) {
            for (DocumentReference parentReference : file.getParentReferences()) {
                Folder folder = this.fileSystem.getFolder(parentReference);
                if (folder == null || this.getChildFileByName(folder, newReference.getName()) == null) continue;
                this.logger.error("A file with the same name [{}] already exists under [{}]", (Object)newReference.getName(), (Object)parentReference);
                return;
            }
        }
        if (this.fileSystem.canEdit(actualNewReference = this.getUniqueReference(newReference))) {
            this.fileSystem.rename(file.getReference(), actualNewReference);
            File newFile = this.fileSystem.getFile(actualNewReference);
            newFile.setName(newReference.getName());
            this.fileSystem.save(newFile);
        } else {
            this.logger.error("You are not allowed to create the file [{}].", (Object)actualNewReference);
        }
    }

    protected DocumentReference getUniqueReference(DocumentReference documentReference) {
        return this.uniqueDocRefGenerator.generate(documentReference.getLastSpaceReference(), new DocumentNameSequence(documentReference.getName()));
    }
}

