/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filemanager.internal.job;

import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.filemanager.File;
import org.xwiki.filemanager.FileSystem;
import org.xwiki.filemanager.Folder;
import org.xwiki.filemanager.Path;
import org.xwiki.filemanager.job.BatchPathRequest;
import org.xwiki.job.AbstractJob;
import org.xwiki.job.DefaultJobStatus;
import org.xwiki.model.reference.DocumentReference;

@Component
@Named(value="fileManager/delete")
public class DeleteJob
extends AbstractJob<BatchPathRequest, DefaultJobStatus<BatchPathRequest>> {
    public static final String JOB_TYPE = "fileManager/delete";
    @Inject
    private FileSystem fileSystem;

    public String getType() {
        return JOB_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInternal() throws Exception {
        Collection<Path> paths = ((BatchPathRequest)this.getRequest()).getPaths();
        if (paths == null) {
            return;
        }
        this.progressManager.pushLevelProgress(paths.size(), (Object)this);
        try {
            for (Path path : paths) {
                this.progressManager.startStep((Object)this);
                this.delete(path);
                this.progressManager.endStep((Object)this);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    private void delete(Path path) {
        if (path.getFileReference() != null) {
            this.deleteFile(path.getFileReference(), path.getFolderReference());
        } else if (path.getFolderReference() != null) {
            this.deleteFolder(path.getFolderReference());
        }
    }

    private void deleteFile(DocumentReference fileReference, DocumentReference parentReference) {
        File file = this.fileSystem.getFile(fileReference);
        if (file != null) {
            Collection<DocumentReference> parentReferences = file.getParentReferences();
            boolean save = parentReferences.remove(parentReference);
            if (parentReferences.isEmpty() || parentReference == null) {
                if (this.fileSystem.canDelete(fileReference)) {
                    this.fileSystem.delete(fileReference);
                } else {
                    this.logger.error("You are not allowed to delete the file [{}].", (Object)fileReference);
                }
            } else if (save) {
                if (this.fileSystem.canEdit(fileReference)) {
                    this.fileSystem.save(file);
                } else {
                    this.logger.error("You are not allowed to edit the file [{}].", (Object)fileReference);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFolder(DocumentReference folderReference) {
        if (this.fileSystem.canDelete(folderReference)) {
            Folder folder = this.fileSystem.getFolder(folderReference);
            if (folder == null) {
                return;
            }
            List<DocumentReference> childFolderReferences = folder.getChildFolderReferences();
            List<DocumentReference> childFileReferences = folder.getChildFileReferences();
            this.progressManager.pushLevelProgress(childFolderReferences.size() + childFileReferences.size() + 1, (Object)this);
            try {
                for (DocumentReference childFolderReference : childFolderReferences) {
                    this.progressManager.startStep((Object)this);
                    this.deleteFolder(childFolderReference);
                    this.progressManager.endStep((Object)this);
                }
                for (DocumentReference childFileReference : childFileReferences) {
                    this.progressManager.startStep((Object)this);
                    this.deleteFile(childFileReference, folderReference);
                    this.progressManager.endStep((Object)this);
                }
                this.progressManager.startStep((Object)this);
                if (folder.getChildFolderReferences().isEmpty() && folder.getChildFileReferences().isEmpty()) {
                    this.fileSystem.delete(folderReference);
                }
                this.progressManager.endStep((Object)this);
            }
            finally {
                this.progressManager.popLevelProgress((Object)this);
            }
        } else {
            this.logger.error("You are not allowed to delete the folder [{}].", (Object)folderReference);
        }
    }
}

