/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filemanager.internal.job;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jgroups.util.UUID;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.filemanager.Path;
import org.xwiki.filemanager.job.BatchPathRequest;
import org.xwiki.filemanager.job.FileManager;
import org.xwiki.filemanager.job.MoveRequest;
import org.xwiki.filemanager.job.PackRequest;
import org.xwiki.job.Job;
import org.xwiki.job.JobException;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.JobStatusStore;
import org.xwiki.job.Request;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.observation.EventListener;

@Component
@Singleton
public class DefaultFileManager
implements FileManager {
    private static final String PROPERTY_USER_REFERENCE = "user.reference";
    private static final String PROPERTY_JOB_TYPE = "job.type";
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private JobExecutor jobExecutor;
    @Inject
    private JobStatusStore jobStatusStore;
    @Inject
    @Named(value="ActiveFileSystemJobQueue")
    private EventListener activeJobQueue;

    @Override
    public String move(Collection<Path> paths, Path destination) throws JobException {
        MoveRequest moveRequest = this.createMoveRequest(paths, destination, "fileManager/move");
        this.jobExecutor.execute("fileManager/move", (Request)moveRequest);
        return this.addToQueue(moveRequest);
    }

    @Override
    public String copy(Collection<Path> paths, Path destination) throws JobException {
        MoveRequest moveRequest = this.createMoveRequest(paths, destination, "fileManager/copy");
        this.jobExecutor.execute("fileManager/copy", (Request)moveRequest);
        return this.addToQueue(moveRequest);
    }

    @Override
    public String delete(Collection<Path> paths) throws JobException {
        BatchPathRequest deleteRequest = this.initBatchPathRequest(new BatchPathRequest(), paths, "fileManager/delete");
        this.jobExecutor.execute("fileManager/delete", (Request)deleteRequest);
        return this.addToQueue(deleteRequest);
    }

    @Override
    public String pack(Collection<Path> paths, AttachmentReference outputFileReference) throws JobException {
        PackRequest packRequest = this.initBatchPathRequest(new PackRequest(), paths, "fileManager/pack");
        packRequest.setOutputFileReference(outputFileReference);
        this.jobExecutor.execute("fileManager/pack", (Request)packRequest);
        return this.addToQueue(packRequest);
    }

    @Override
    public JobStatus getJobStatus(String jobId) {
        List<String> jobStatusId = this.getJobStatusId(jobId);
        Job job = this.jobExecutor.getJob(jobStatusId);
        if (job != null) {
            return job.getStatus();
        }
        return this.jobStatusStore.getJobStatus(jobStatusId);
    }

    @Override
    public List<String> getActiveJobs() {
        return new ArrayList<String>((Queue)this.activeJobQueue);
    }

    private <T extends BatchPathRequest> T initBatchPathRequest(T request, Collection<Path> paths, String jobType) {
        request.setId(this.getJobStatusId(UUID.randomUUID().toString()));
        request.setPaths(new LinkedList<Path>(paths));
        request.setProperty(PROPERTY_USER_REFERENCE, this.documentAccessBridge.getCurrentUserReference());
        request.setProperty(PROPERTY_JOB_TYPE, jobType);
        return request;
    }

    private MoveRequest createMoveRequest(Collection<Path> paths, Path destination, String jobType) {
        MoveRequest moveRequest = this.initBatchPathRequest(new MoveRequest(), paths, jobType);
        moveRequest.setDestination(destination);
        moveRequest.setInteractive(false);
        return moveRequest;
    }

    private List<String> getJobStatusId(String jobId) {
        return Arrays.asList("file-manager", jobId);
    }

    private String addToQueue(BatchPathRequest request) {
        String jobId = (String)request.getId().get(1);
        ((Queue)this.activeJobQueue).offer(jobId);
        return jobId;
    }
}

