/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filemanager.internal.job;

import java.util.Collection;
import java.util.List;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.filemanager.File;
import org.xwiki.filemanager.Folder;
import org.xwiki.filemanager.Path;
import org.xwiki.filemanager.internal.job.MoveJob;
import org.xwiki.filemanager.job.MoveRequest;
import org.xwiki.model.reference.DocumentReference;

@Component
@Named(value="fileManager/copy")
public class CopyJob
extends MoveJob {
    public static final String JOB_TYPE = "fileManager/copy";

    @Override
    public String getType() {
        return JOB_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runInternal() throws Exception {
        Collection<Path> paths = ((MoveRequest)this.getRequest()).getPaths();
        Path destination = ((MoveRequest)this.getRequest()).getDestination();
        if (paths == null || destination == null || destination.getFolderReference() == null || !this.fileSystem.exists(destination.getFolderReference())) {
            return;
        }
        this.progressManager.pushLevelProgress(paths.size(), (Object)this);
        try {
            for (Path path : paths) {
                this.progressManager.startStep((Object)this);
                this.copy(path, destination);
                this.progressManager.endStep((Object)this);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    private void copy(Path path, Path destination) {
        if (path.getFileReference() != null) {
            this.copyFile(path.getFileReference(), destination);
        } else if (path.getFolderReference() != null) {
            this.copyFolder(path.getFolderReference(), destination);
        }
    }

    private void copyFile(DocumentReference fileReference, Path destination) {
        File file = this.fileSystem.getFile(fileReference);
        if (file != null) {
            if (this.fileSystem.canView(fileReference)) {
                boolean copyToDifferentFolder;
                Collection<DocumentReference> parentReferences = file.getParentReferences();
                boolean bl = copyToDifferentFolder = !parentReferences.contains(destination.getFolderReference());
                if (destination.getFileReference() == null && copyToDifferentFolder) {
                    DocumentReference copyReference = new DocumentReference(file.getName(), fileReference.getLastSpaceReference());
                    this.copyFile(file, new Path(destination.getFolderReference(), copyReference));
                } else if (destination.getFileReference() != null && (!destination.getFileReference().getName().equals(file.getName()) || copyToDifferentFolder)) {
                    this.copyFile(file, destination);
                }
            } else {
                this.logger.error("You are not allowed to copy the file [{}].", (Object)fileReference);
            }
        }
    }

    private void copyFile(File file, Path destination) {
        Folder folder = this.fileSystem.getFolder(destination.getFolderReference());
        if (!this.prepareOverwrite(destination.getFileReference().getName(), folder, file.getReference())) {
            return;
        }
        DocumentReference copyReference = this.getUniqueReference(destination.getFileReference());
        if (this.fileSystem.canEdit(copyReference)) {
            this.fileSystem.copy(file.getReference(), copyReference);
            File copy = this.fileSystem.getFile(copyReference);
            if (copy != null) {
                copy.setName(destination.getFileReference().getName());
                Collection<DocumentReference> parentReferences = copy.getParentReferences();
                parentReferences.clear();
                parentReferences.add(destination.getFolderReference());
                this.fileSystem.save(copy);
            }
        } else {
            this.logger.error("You are not allowed to create the file [{}].", (Object)copyReference);
        }
    }

    private void copyFolder(DocumentReference folderReference, Path destination) {
        if (this.isDescendantOrSelf(destination.getFolderReference(), folderReference)) {
            this.logger.error("Cannot copy [{}] to a sub-folder of itself.", (Object)folderReference);
            return;
        }
        Folder folder = this.fileSystem.getFolder(folderReference);
        if (folder != null) {
            if (this.fileSystem.canView(folderReference)) {
                boolean copyToDifferentFolder;
                boolean bl = copyToDifferentFolder = !destination.getFolderReference().equals((Object)folder.getParentReference());
                if (destination.getFileReference() == null && copyToDifferentFolder) {
                    DocumentReference copyReference = new DocumentReference(folder.getName(), folderReference.getLastSpaceReference());
                    this.copyFolder(folder, new Path(destination.getFolderReference(), copyReference));
                } else if (destination.getFileReference() != null && (!destination.getFileReference().getName().equals(folder.getName()) || copyToDifferentFolder)) {
                    this.copyFolder(folder, destination);
                }
            } else {
                this.logger.error("You are not allowed to copy the folder [{}].", (Object)folderReference);
            }
        }
    }

    private void copyFolder(Folder folder, Path destination) {
        Folder newParent = this.fileSystem.getFolder(destination.getFolderReference());
        Folder child = this.getChildFolderByName(newParent, destination.getFileReference().getName());
        if (child != null) {
            this.copyContent(folder, child.getReference());
        } else {
            DocumentReference copyReference = this.getUniqueReference(destination.getFileReference());
            if (this.fileSystem.canEdit(copyReference)) {
                this.fileSystem.copy(folder.getReference(), copyReference);
                Folder copy = this.fileSystem.getFolder(copyReference);
                if (copy != null) {
                    copy.setName(destination.getFileReference().getName());
                    copy.setParentReference(destination.getFolderReference());
                    this.fileSystem.save(copy);
                    this.copyContent(folder, copyReference);
                }
            } else {
                this.logger.error("You are not allowed to create the folder [{}].", (Object)copyReference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyContent(Folder source, DocumentReference destination) {
        Path destinationPath = new Path(destination);
        List<DocumentReference> childFolderReferences = source.getChildFolderReferences();
        List<DocumentReference> childFileReferences = source.getChildFileReferences();
        this.progressManager.pushLevelProgress(childFolderReferences.size() + childFileReferences.size(), (Object)this);
        try {
            for (DocumentReference childFileReference : childFileReferences) {
                this.progressManager.startStep((Object)this);
                this.copyFile(childFileReference, destinationPath);
                this.progressManager.endStep((Object)this);
            }
            for (DocumentReference childFolderReference : childFolderReferences) {
                this.progressManager.startStep((Object)this);
                this.copyFolder(childFolderReference, destinationPath);
                this.progressManager.endStep((Object)this);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }
}

