/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filemanager.internal.job;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.event.JobFinishedEvent;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="ActiveFileSystemJobQueue")
@Singleton
public class ActiveJobQueue
extends ConcurrentLinkedQueue<String>
implements EventListener {
    public static final String NAME = "ActiveFileSystemJobQueue";
    private static final long serialVersionUID = 1L;

    public List<Event> getEvents() {
        return Collections.singletonList(new JobFinishedEvent());
    }

    public String getName() {
        return NAME;
    }

    public void onEvent(Event event, Object source, Object data) {
        List jobId = ((JobFinishedEvent)event).getJobId();
        if (jobId != null && jobId.size() == 2 && "file-manager".equals(jobId.get(0))) {
            this.remove(jobId.get(1));
        }
    }
}

