/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filemanager.internal;

import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.filemanager.Folder;
import org.xwiki.filemanager.internal.AbstractDocument;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultFolder
extends AbstractDocument
implements Folder {
    private static final String PARAMETER_SPACE = "space";
    @Inject
    @Named(value="explicit")
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> localEntityReferenceSerializer;
    @Inject
    private QueryManager queryManager;

    @Override
    public DocumentReference getParentReference() {
        return this.getDocument().getParentReference();
    }

    @Override
    public void setParentReference(DocumentReference parentReference) {
        XWikiDocument document = this.getClonedDocument();
        if (parentReference != null) {
            if (parentReference.getWikiReference().equals((Object)this.getReference().getWikiReference())) {
                document.setParentReference(parentReference.removeParent((EntityReference)parentReference.getWikiReference()));
            } else {
                document.setParentReference(parentReference.extractReference(EntityType.DOCUMENT));
            }
        } else {
            document.setParentReference((EntityReference)null);
        }
    }

    @Override
    public List<DocumentReference> getChildFolderReferences() {
        try {
            String statement = "from doc.object(FileManagerCode.FolderClass) as folder where doc.space = :space and doc.parent = :parent";
            Query query = this.queryManager.createQuery(statement, "xwql");
            query.bindValue(PARAMETER_SPACE, this.localEntityReferenceSerializer.serialize((EntityReference)this.getReference().getLastSpaceReference(), new Object[0]));
            query.bindValue("parent", this.localEntityReferenceSerializer.serialize((EntityReference)this.getReference(), new Object[0]));
            query.setWiki(this.getReference().getWikiReference().getName());
            LinkedList<DocumentReference> childFolderReferences = new LinkedList<DocumentReference>();
            for (Object result : query.execute()) {
                childFolderReferences.add(this.documentReferenceResolver.resolve((Object)((String)result), new Object[]{this.getReference()}));
            }
            return childFolderReferences;
        }
        catch (QueryException e) {
            this.logger.error("Failed to retrieve the child folders of [{}]", (Object)this.getReference(), (Object)e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<DocumentReference> getChildFileReferences() {
        try {
            String statement = "from doc.object(FileManagerCode.FileClass) as file where doc.space = :space and :tag member of doc.object(XWiki.TagClass).tags";
            Query query = this.queryManager.createQuery(statement, "xwql");
            query.bindValue(PARAMETER_SPACE, this.localEntityReferenceSerializer.serialize((EntityReference)this.getReference().getLastSpaceReference(), new Object[0]));
            query.bindValue("tag", (Object)this.getReference().getName());
            query.setWiki(this.getReference().getWikiReference().getName());
            LinkedList<DocumentReference> childFolderReferences = new LinkedList<DocumentReference>();
            for (Object result : query.execute()) {
                childFolderReferences.add(this.documentReferenceResolver.resolve((Object)((String)result), new Object[]{this.getReference()}));
            }
            return childFolderReferences;
        }
        catch (QueryException e) {
            this.logger.error("Failed to retrieve the child files of [{}]", (Object)this.getReference(), (Object)e);
            return Collections.emptyList();
        }
    }
}

