/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filemanager.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.filemanager.Document;
import org.xwiki.filemanager.File;
import org.xwiki.filemanager.FileSystem;
import org.xwiki.filemanager.Folder;
import org.xwiki.filemanager.internal.AbstractDocument;
import org.xwiki.filemanager.internal.DefaultFile;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Singleton
public class DefaultFileSystem
implements FileSystem {
    @Inject
    private Logger logger;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private Provider<Folder> folderProvider;
    @Inject
    private Provider<File> fileProvider;
    @Inject
    private ContextualAuthorizationManager authorization;

    @Override
    public Folder getFolder(DocumentReference folderReference) {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        try {
            XWikiDocument document = context.getWiki().getDocument(folderReference, context);
            if (document.isNew()) {
                return null;
            }
            Folder folder = (Folder)this.folderProvider.get();
            if (folder instanceof AbstractDocument) {
                ((AbstractDocument)((Object)folder)).setDocument(document);
                return folder;
            }
            this.logger.warn("Unsupported folder implementation [{}]. This file system works only with folders that extend AbstractDocument.", (Object)folder.getClass().getName());
            return null;
        }
        catch (Exception e) {
            this.logger.error("Failed to retrieve folder document [{}].", (Object)folderReference, (Object)e);
            return null;
        }
    }

    @Override
    public File getFile(DocumentReference fileReference) {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        try {
            XWikiDocument document = context.getWiki().getDocument(fileReference, context);
            if (document.isNew()) {
                return null;
            }
            File file = (File)this.fileProvider.get();
            if (file instanceof AbstractDocument) {
                ((AbstractDocument)((Object)file)).setDocument(document);
                return file;
            }
            this.logger.warn("Unsupported file implementation [{}]. This file system works only with files that extend AbstractDocument.", (Object)file.getClass().getName());
            return null;
        }
        catch (Exception e) {
            this.logger.error("Failed to retrieve file document [{}].", (Object)fileReference, (Object)e);
            return null;
        }
    }

    @Override
    public boolean exists(DocumentReference reference) {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        try {
            return context.getWiki().exists(reference, context);
        }
        catch (XWikiException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean canView(DocumentReference reference) {
        return this.authorization.hasAccess(Right.VIEW, (EntityReference)reference);
    }

    @Override
    public boolean canEdit(DocumentReference reference) {
        return this.authorization.hasAccess(Right.EDIT, (EntityReference)reference);
    }

    @Override
    public boolean canDelete(DocumentReference reference) {
        return this.authorization.hasAccess(Right.DELETE, (EntityReference)reference);
    }

    @Override
    public void save(Document document) {
        if (document instanceof AbstractDocument) {
            XWikiContext context = (XWikiContext)this.xcontextProvider.get();
            try {
                if (document instanceof DefaultFile) {
                    ((DefaultFile)document).updateParentReferences();
                }
                XWikiDocument xdoc = ((AbstractDocument)document).getClonedDocument();
                DocumentReference currentUserReference = context.getUserReference();
                if (currentUserReference == null) {
                    String currentWiki = xdoc.getDocumentReference().getWikiReference().getName();
                    currentUserReference = new DocumentReference(currentWiki, "XWiki", "XWikiGuest");
                }
                xdoc.setAuthorReference(currentUserReference);
                if (xdoc.isContentDirty() || xdoc.isMetaDataDirty()) {
                    context.getWiki().saveDocument(xdoc, "", false, context);
                }
            }
            catch (XWikiException e) {
                this.logger.error("Failed to save document [{}].", (Object)document.getReference(), (Object)e);
            }
        }
    }

    @Override
    public void delete(DocumentReference reference) {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        try {
            XWikiDocument document = context.getWiki().getDocument(reference, context);
            if (!document.isNew()) {
                context.getWiki().deleteDocument(document.clone(), context);
            }
        }
        catch (XWikiException e) {
            this.logger.error("Failed to delete document [{}].", (Object)reference, (Object)e);
        }
    }

    @Override
    public void rename(DocumentReference oldReference, DocumentReference newReference) {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        try {
            context.getWiki().getDocument(oldReference, context).clone().rename(newReference, context);
        }
        catch (XWikiException e) {
            this.logger.error("Failed to rename document [{}] to [{}]", new Object[]{oldReference, newReference, e});
        }
    }

    @Override
    public void copy(DocumentReference source, DocumentReference target) {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        try {
            context.getWiki().copyDocument(source, target, null, false, true, true, context);
        }
        catch (XWikiException e) {
            this.logger.error("Failed to copy [{}] as [{}].", new Object[]{source, target, e});
        }
    }
}

