/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filemanager.internal;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.filemanager.File;
import org.xwiki.filemanager.internal.AbstractDocument;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultFile
extends AbstractDocument
implements File {
    static final EntityReference TAG_CLASS_REFERENCE = new EntityReference("TagClass", EntityType.DOCUMENT, new EntityReference("XWiki", EntityType.SPACE));
    static final String PROPERTY_TAGS = "tags";
    private Collection<DocumentReference> parentReferences;

    @Override
    public String getName() {
        List attachments = this.getDocument().getAttachmentList();
        if (attachments.size() > 0) {
            return ((XWikiAttachment)attachments.get(0)).getFilename();
        }
        return super.getName();
    }

    @Override
    public void setName(String name) {
        if (this.getName().equals(name)) {
            return;
        }
        super.setName(name);
        XWikiDocument document = this.getClonedDocument();
        List attachments = document.getAttachmentList();
        if (attachments.size() > 0) {
            XWikiAttachment oldAttachment = (XWikiAttachment)attachments.get(0);
            try {
                document.removeAttachment(oldAttachment, false);
                document.setAttachment(name, oldAttachment.getContentInputStream(this.getContext()), this.getContext());
            }
            catch (Exception e) {
                this.logger.error("Failed to rename file [{}] to [{}].", new Object[]{oldAttachment.getReference(), name, e});
            }
        }
    }

    @Override
    public Collection<DocumentReference> getParentReferences() {
        if (this.parentReferences == null) {
            this.parentReferences = this.retrieveParentReferences();
        }
        return this.parentReferences;
    }

    void updateParentReferences() {
        if (this.parentReferences == null) {
            return;
        }
        XWikiDocument document = this.getClonedDocument();
        BaseObject tagObject = document.getXObject(TAG_CLASS_REFERENCE);
        if (tagObject == null) {
            tagObject = new BaseObject();
            tagObject.setXClassReference(TAG_CLASS_REFERENCE);
            document.addXObject(tagObject);
        }
        ArrayList<String> tags = new ArrayList<String>();
        for (DocumentReference parentReference : this.parentReferences) {
            tags.add(parentReference.getName());
        }
        tagObject.setStringListValue(PROPERTY_TAGS, tags);
        if (this.parentReferences.isEmpty()) {
            document.setParentReference((EntityReference)null);
        } else {
            DocumentReference parentReference = this.parentReferences.iterator().next();
            if (parentReference.getWikiReference().equals((Object)this.getReference().getWikiReference())) {
                document.setParentReference(parentReference.removeParent((EntityReference)parentReference.getWikiReference()));
            } else {
                document.setParentReference(parentReference.extractReference(EntityType.DOCUMENT));
            }
        }
        this.parentReferences = null;
    }

    private Collection<DocumentReference> retrieveParentReferences() {
        ArrayList<DocumentReference> references = new ArrayList<DocumentReference>();
        BaseObject tagObject = this.getDocument().getXObject(TAG_CLASS_REFERENCE);
        if (tagObject != null) {
            try {
                List tags = (List)((BaseProperty)tagObject.get(PROPERTY_TAGS)).getValue();
                if (tags != null) {
                    for (String tag : tags) {
                        references.add(new DocumentReference(tag, this.getReference().getLastSpaceReference()));
                    }
                }
            }
            catch (XWikiException e) {
                this.logger.error("Failed to retrieve the list of tags for file [{}].", (Object)this.getReference(), (Object)e);
            }
        }
        return references;
    }

    @Override
    public InputStream getContent() {
        List attachments = this.getDocument().getAttachmentList();
        if (attachments.size() > 0) {
            try {
                return ((XWikiAttachment)attachments.get(0)).getContentInputStream(this.getContext());
            }
            catch (XWikiException e) {
                this.logger.warn("Failed to get the file content input stream for [{}]. Returning empty content instead.", (Object)this.getReference(), (Object)e);
                return new ByteArrayInputStream(new byte[0]);
            }
        }
        return new ByteArrayInputStream(new byte[0]);
    }
}

