/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filemanager.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.xwiki.filemanager.Document;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.rendering.syntax.Syntax;

public abstract class AbstractDocument
implements Document {
    @Inject
    protected Logger logger;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    private XWikiDocument document;
    private boolean cloned;

    @Override
    public DocumentReference getReference() {
        return this.document.getDocumentReference();
    }

    @Override
    public String getName() {
        return this.document.getRenderedTitle(Syntax.PLAIN_1_0, this.getContext());
    }

    @Override
    public void setName(String name) {
        this.getClonedDocument().setTitle(name);
    }

    XWikiDocument getDocument() {
        return this.document;
    }

    protected XWikiDocument getClonedDocument() {
        if (!this.cloned) {
            this.document = this.document.clone();
            this.cloned = true;
        }
        return this.document;
    }

    void setDocument(XWikiDocument document) {
        this.document = document;
        this.cloned = false;
    }

    protected XWikiContext getContext() {
        return (XWikiContext)this.xcontextProvider.get();
    }
}

