/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.diagram.export.script;

import com.xwiki.diagram.export.DiagramExportConfiguration;
import com.xwiki.diagram.export.internal.DiagramExportRequest;
import com.xwiki.diagram.export.internal.DiagramExportRequestFactory;
import com.xwiki.diagram.export.internal.HTTPDiagramExporter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.stability.Unstable;

@Component
@Named(value="diagram.exporter")
@Singleton
@Unstable
public class DiagramExporterScriptService
implements ScriptService {
    @Inject
    private Logger logger;
    @Inject
    private DiagramExportConfiguration configuration;
    @Inject
    private HTTPDiagramExporter diagramExporter;
    @Inject
    private DiagramExportRequestFactory diagramExportRequestFactory;
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    private DocumentAccessBridge documentAccessBridge;

    public void export(HttpServletRequest request, HttpServletResponse response) throws IOException {
        DiagramExportRequest diagramExportRequest = this.validateRequest(request, response);
        if (diagramExportRequest == null) {
            return;
        }
        try {
            long start = System.currentTimeMillis();
            this.diagramExporter.export(diagramExportRequest, response);
            long memory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            long duration = System.currentTimeMillis() - start;
            this.logger.debug("Diagram export: ip=" + request.getRemoteAddr() + " referer=\"" + request.getHeader("Referer") + "\" length=" + request.getContentLength() + " memory=" + memory + " duration=" + duration);
        }
        catch (OutOfMemoryError e) {
            Runtime runtime = Runtime.getRuntime();
            this.logger.error("Out of memory while exporting diagram. Memory status: free memory [{}], total memory [{}], max memory [{}].", new Object[]{runtime.freeMemory(), runtime.totalMemory(), runtime.maxMemory(), e});
            response.setStatus(500);
        }
        catch (Exception e) {
            this.logger.error("Failed to export diagram.", (Throwable)e);
            response.setStatus(500);
        }
    }

    private DiagramExportRequest validateRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block8: {
            if (request.getContentLength() < this.configuration.getMaxRequestSize()) {
                try {
                    DiagramExportRequest diagramExportRequest = this.diagramExportRequestFactory.createDiagramExportRequest((ServletRequest)request);
                    if (this.authorization.hasAccess(Right.VIEW, (EntityReference)diagramExportRequest.diagramReference)) {
                        if (diagramExportRequest.xml == null) {
                            diagramExportRequest.xml = this.documentAccessBridge.getDocumentContentForDefaultLanguage(diagramExportRequest.diagramReference);
                        }
                        if (!StringUtils.isBlank((CharSequence)diagramExportRequest.xml)) {
                            return diagramExportRequest;
                        }
                        response.sendError(400, "Nothing to export.");
                        break block8;
                    }
                    response.sendError(403, "You are not allowed to view [" + String.valueOf(diagramExportRequest.diagramReference) + "] diagram.");
                }
                catch (UnsupportedEncodingException | IllegalArgumentException e) {
                    this.logger.warn("Invalid diagram export request. Root cause is [{}].", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                    response.sendError(400, e.getMessage());
                }
                catch (Exception e) {
                    this.logger.error("Failed to process diagram export request.", (Throwable)e);
                    response.sendError(500, ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
            } else {
                response.sendError(413, "The request content length exceeds the [" + this.configuration.getMaxRequestSize() + "] limit.");
            }
        }
        return null;
    }
}

