/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.diagram.export.internal;

import com.mxpdf.text.DocumentException;
import com.xwiki.diagram.export.internal.DiagramExportRequest;
import com.xwiki.diagram.export.internal.DiagramExporter;
import java.io.IOException;
import java.io.OutputStream;
import javax.inject.Singleton;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import org.xwiki.component.annotation.Component;

@Component(roles={HTTPDiagramExporter.class})
@Singleton
public class HTTPDiagramExporter
extends DiagramExporter {
    public void export(DiagramExportRequest request, HttpServletResponse response) throws IOException, DocumentException, SAXException, ParserConfigurationException {
        try (ServletOutputStream out = response.getOutputStream();){
            if ("pdf".equals(request.format)) {
                this.exportAsPDF(request, response);
            } else {
                this.exportAsImage(request, response);
            }
            response.setStatus(200);
        }
    }

    private void exportAsImage(DiagramExportRequest request, HttpServletResponse response) throws IOException, SAXException, ParserConfigurationException {
        if (request.outputFileName != null) {
            response.setContentType("application/x-unknown");
            this.setContentDisposition(response, request.outputFileName);
        } else if (request.format != null) {
            response.setContentType("image/" + request.format.toLowerCase());
        }
        this.exportAsImage(request, (OutputStream)response.getOutputStream());
    }

    private void exportAsPDF(DiagramExportRequest request, HttpServletResponse response) throws DocumentException, IOException, SAXException, ParserConfigurationException {
        response.setContentType("application/pdf");
        if (request.outputFileName != null) {
            this.setContentDisposition(response, request.outputFileName);
        }
        this.exportAsPDF(request, (OutputStream)response.getOutputStream());
    }

    private void setContentDisposition(HttpServletResponse response, String fileName) {
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"; filename*=UTF-8''" + fileName);
    }
}

