/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.diagram.export.internal;

import com.mxgraph.io.mxCodec;
import com.mxgraph.online.Utils;
import com.mxgraph.util.mxBase64;
import com.mxgraph.util.mxXmlUtils;
import com.mxgraph.view.mxGraph;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xwiki.component.annotation.Component;

@Component(roles={DiagramXMLParser.class})
@Singleton
public class DiagramXMLParser {
    private static final String TAG_DIAGRAM = "diagram";
    private static final String TAG_MX_GRAPH_MODEL = "mxGraphModel";
    private static final Set<Integer> ALLOWED_CONTROL_CHARS = new HashSet<Integer>(Arrays.asList(9, 10, 13));
    @Inject
    private Logger logger;

    public mxGraph parse(String xml) {
        Element graphModelElement = this.extractGraphModel(mxXmlUtils.parseXml((String)xml));
        if (graphModelElement == null) {
            return null;
        }
        mxCodec decoder = new mxCodec(graphModelElement.getOwnerDocument());
        mxGraph graph = new mxGraph();
        decoder.decode((Node)graphModelElement, (Object)graph.getModel());
        return graph;
    }

    private Element extractGraphModel(Document document) {
        Element graphModel = document.getDocumentElement();
        Element diagramElement = this.getDiagramElement(document);
        if (diagramElement != null) {
            graphModel = this.parseDiagram(diagramElement);
        }
        if (graphModel != null && !TAG_MX_GRAPH_MODEL.equalsIgnoreCase(graphModel.getTagName())) {
            graphModel = null;
        }
        return graphModel;
    }

    private Element getDiagramElement(Document document) {
        NodeList diagrams;
        Element root = document.getDocumentElement();
        if (TAG_DIAGRAM.equalsIgnoreCase(root.getTagName())) {
            return root;
        }
        if ("mxfile".equalsIgnoreCase(root.getTagName()) && (diagrams = root.getElementsByTagName(TAG_DIAGRAM)).getLength() > 0) {
            return (Element)diagrams.item(0);
        }
        return null;
    }

    private Element parseDiagram(Element diagramElement) {
        Element firstChildElement = this.getFirstChildElement(diagramElement);
        String text = diagramElement.getTextContent().trim();
        if (firstChildElement != null && TAG_MX_GRAPH_MODEL.equalsIgnoreCase(firstChildElement.getTagName())) {
            return firstChildElement;
        }
        if (!text.isEmpty()) {
            try {
                String xml = this.decompress(text);
                if (!StringUtils.isBlank((CharSequence)xml)) {
                    return mxXmlUtils.parseXml((String)xml).getDocumentElement();
                }
            }
            catch (IOException e) {
                this.logger.error("Failed to decompress diagram XML.", (Throwable)e);
            }
        }
        return null;
    }

    private Element getFirstChildElement(Element parent) {
        Node child;
        for (child = parent.getFirstChild(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
        }
        return (Element)child;
    }

    private String decompress(String text) throws IOException {
        byte[] base64Ddecoded = mxBase64.decodeFast((String)text);
        String inflated = Utils.inflate((byte[])base64Ddecoded);
        String urlDecoded = URLDecoder.decode(inflated, "UTF-8");
        return this.zapGremlins(urlDecoded);
    }

    private String zapGremlins(String text) {
        StringBuilder result = new StringBuilder();
        text.chars().filter(this::isNotGremlin).forEach(result::appendCodePoint);
        return result.toString();
    }

    private boolean isNotGremlin(int code) {
        return (code >= 32 || ALLOWED_CONTROL_CHARS.contains(code)) && code != 65535 && code != 65534;
    }
}

