/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.diagram.export.internal;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.canvas.mxICanvas;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxGraph;
import com.mxpdf.text.Document;
import com.mxpdf.text.DocumentException;
import com.mxpdf.text.PageSize;
import com.mxpdf.text.Rectangle;
import com.mxpdf.text.pdf.PdfContentByte;
import com.mxpdf.text.pdf.PdfWriter;
import com.xwiki.diagram.export.internal.DiagramExportRequest;
import com.xwiki.diagram.export.internal.DiagramXMLParser;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.BiFunction;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.xml.sax.SAXException;
import org.xwiki.component.annotation.Component;

@Component(roles={DiagramExporter.class})
@Singleton
public class DiagramExporter {
    @Inject
    private Logger logger;
    @Inject
    private DiagramXMLParser xmlParser;

    public void export(DiagramExportRequest request, OutputStream outputStream) throws IOException, DocumentException, SAXException, ParserConfigurationException {
        if ("pdf".equals(request.format)) {
            this.exportAsPDF(request, outputStream);
        } else {
            this.exportAsImage(request, outputStream);
        }
    }

    protected void exportAsImage(DiagramExportRequest request, OutputStream outputStream) throws IOException, SAXException, ParserConfigurationException {
        BufferedImage image = mxUtils.createBufferedImage((int)request.width, (int)request.height, (Color)request.backgroundColor);
        this.drawToCanvas(request, (width, height) -> {
            Graphics2D graphics2D = image.createGraphics();
            mxUtils.setAntiAlias((Graphics2D)graphics2D, (boolean)true, (boolean)true);
            return graphics2D;
        });
        ImageIO.write((RenderedImage)image, request.format, outputStream);
    }

    protected void exportAsPDF(DiagramExportRequest request, OutputStream outputStream) throws DocumentException, IOException, SAXException, ParserConfigurationException {
        Rectangle pageSize = PageSize.A4;
        if (request.width != null && request.height != null) {
            pageSize = new Rectangle((float)request.width.intValue(), (float)request.height.intValue());
        }
        Document document = new Document(pageSize);
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        document.open();
        this.drawToCanvas(request, (arg_0, arg_1) -> ((PdfContentByte)writer.getDirectContent()).createGraphics(arg_0, arg_1));
        document.close();
    }

    private void drawToCanvas(DiagramExportRequest request, final BiFunction<Integer, Integer, Graphics2D> graphicsFactory) {
        mxGraphics2DCanvas canvas;
        mxGraph graph = this.xmlParser.parse(request.xml);
        if (graph == null) {
            this.logger.warn("The specified diagram is not valid and thus it can't be drawn.");
            return;
        }
        this.configureGraph(graph, request);
        mxRectangle clip = null;
        if (request.width != null && request.height != null) {
            clip = new mxRectangle(0.0, 0.0, (double)request.width.intValue(), (double)request.height.intValue());
        }
        if ((canvas = (mxGraphics2DCanvas)mxCellRenderer.drawCells((mxGraph)graph, null, (double)request.scale, clip, (mxCellRenderer.CanvasFactory)new mxCellRenderer.CanvasFactory(){

            public mxICanvas createCanvas(int width, int height) {
                return new mxGraphics2DCanvas((Graphics2D)graphicsFactory.apply(width, height));
            }
        })) != null) {
            canvas.getGraphics().dispose();
        }
    }

    private void configureGraph(mxGraph graph, DiagramExportRequest request) {
        if (request.borderWidth != null) {
            graph.setBorder(request.borderWidth.intValue());
        }
        graph.setEnabled(false);
        graph.setHtmlLabels(true);
    }
}

