/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.diagram.export.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mxgraph.util.mxUtils;
import com.xwiki.diagram.export.DiagramExportConfiguration;
import com.xwiki.diagram.export.internal.DiagramExportRequest;
import java.awt.Color;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReferenceResolver;

@Component(roles={DiagramExportRequestFactory.class})
@Singleton
public class DiagramExportRequestFactory {
    private static final String UTF8 = "UTF-8";
    @Inject
    private DiagramExportConfiguration configuration;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> currentStringDocumentReferenceResolver;

    public DiagramExportRequest createDiagramExportRequest(ServletRequest request) throws UnsupportedEncodingException {
        DiagramExportRequest diagramExportRequest = new DiagramExportRequest();
        diagramExportRequest.diagramReference = this.currentStringDocumentReferenceResolver.resolve((Object)StringUtils.defaultString((String)request.getParameter("diagramReference")), new Object[0]);
        diagramExportRequest.format = request.getParameter("format");
        if (StringUtils.isEmpty((CharSequence)diagramExportRequest.format)) {
            throw new IllegalArgumentException("Export format must be specified.");
        }
        this.setWidthAndHeight(diagramExportRequest, request);
        this.setBackgroundColor(diagramExportRequest, request);
        this.setScale(diagramExportRequest, request);
        this.setExtras(diagramExportRequest, request);
        diagramExportRequest.dotsPerInch = this.getInteger(request, "dpi", 1, "Invalid export DPI.");
        diagramExportRequest.borderWidth = this.getInteger(request, "border", 0, "Invalid export border width.");
        diagramExportRequest.base64 = this.getBoolean(request, "base64");
        diagramExportRequest.embedXML = this.getBoolean(request, "embedXml");
        diagramExportRequest.outputFileName = request.getParameter("filename");
        if (StringUtils.endsWithIgnoreCase((CharSequence)diagramExportRequest.outputFileName, (CharSequence)".xml")) {
            diagramExportRequest.outputFileName = diagramExportRequest.outputFileName.substring(0, diagramExportRequest.outputFileName.length() - 3) + diagramExportRequest.format;
        }
        diagramExportRequest.xml = request.getParameter("xml");
        if (StringUtils.startsWith((CharSequence)diagramExportRequest.xml, (CharSequence)"%3C")) {
            diagramExportRequest.xml = URLDecoder.decode(diagramExportRequest.xml, UTF8);
        }
        return diagramExportRequest;
    }

    private void setWidthAndHeight(DiagramExportRequest diagramExportRequest, ServletRequest request) {
        diagramExportRequest.width = this.getInteger(request, "w", 1, "Invalid export width.");
        diagramExportRequest.height = this.getInteger(request, "h", 1, "Invalid export height.");
        if (diagramExportRequest.width != null && diagramExportRequest.height != null && diagramExportRequest.width * diagramExportRequest.height >= this.configuration.getMaxArea()) {
            throw new IllegalArgumentException("Export area (width * height) too large.");
        }
    }

    private Integer getInteger(ServletRequest request, String key, int minValue, String message) {
        Integer integerValue = null;
        String value = request.getParameter(key);
        if (value != null && (integerValue = Integer.valueOf(Integer.parseInt(value))) < minValue) {
            throw new IllegalArgumentException(message);
        }
        return integerValue;
    }

    private boolean getBoolean(ServletRequest request, String key) {
        String value = request.getParameter(key);
        return "1".equals(value) || Boolean.valueOf(value) != false;
    }

    private void setBackgroundColor(DiagramExportRequest diagramExportRequest, ServletRequest request) {
        String backgroundColor = request.getParameter("bg");
        Color color = diagramExportRequest.backgroundColor = backgroundColor != null ? mxUtils.parseColor((String)backgroundColor) : null;
        if (diagramExportRequest.backgroundColor == null && !"png".equals(diagramExportRequest.format)) {
            diagramExportRequest.backgroundColor = Color.WHITE;
        }
    }

    private void setScale(DiagramExportRequest diagramExportRequest, ServletRequest request) {
        String value = request.getParameter("scale");
        if (value != null) {
            diagramExportRequest.scale = Double.parseDouble(value);
            if (diagramExportRequest.scale <= 0.0) {
                throw new IllegalArgumentException("Invalid export scale.");
            }
        }
    }

    private void setExtras(DiagramExportRequest diagramExportRequest, ServletRequest request) throws UnsupportedEncodingException {
        String json = request.getParameter("extras");
        if (StringUtils.startsWith((CharSequence)json, (CharSequence)"%7B")) {
            json = URLDecoder.decode(json, UTF8);
        }
        if (StringUtils.isNotBlank((CharSequence)json)) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                diagramExportRequest.extras = (Map)objectMapper.readValue(json, Map.class);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid JSON for the extras export parameter.", e);
            }
        }
    }
}

