/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.diagram.script;

import com.xwiki.diagram.internal.DiagramImporter;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.script.service.ScriptService;
import org.xwiki.script.service.ScriptServiceManager;
import org.xwiki.stability.Unstable;

@Component
@Named(value="diagram")
@Singleton
@Unstable
public class DiagramScriptService
implements ScriptService {
    public static final String ROLEHINT = "diagram";
    @Inject
    private ScriptServiceManager scriptServiceManager;
    @Inject
    private DiagramImporter diagramImporter;
    @Inject
    private Logger logger;

    public <S extends ScriptService> S get(String serviceName) {
        return (S)this.scriptServiceManager.get("diagram." + serviceName);
    }

    @Unstable
    public String importDiagram(String diagram, String fileName) {
        try {
            return this.diagramImporter.importDiagram(diagram, fileName);
        }
        catch (Exception e) {
            this.logger.error("Cannot import diagram.", (Throwable)e);
            return null;
        }
    }
}

