/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.diagram.internal.rest;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xwiki.diagram.DiagramResources;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rest.XWikiResource;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.stability.Unstable;

@Component
@Named(value="com.xwiki.diagram.internal.rest.DiagramResourcesImpl")
@Singleton
@Unstable
public class DiagramResourcesImpl
extends XWikiResource
implements DiagramResources {
    private static final String PREFIX = "diagram";
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private DocumentReferenceResolver<String> resolver;
    @Inject
    private Provider<XWikiContext> contextProvider;

    @Override
    public Response deleteAttachments(String documentReference) throws Exception {
        String decodedReference;
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        XWiki xwiki = context.getWiki();
        XWikiDocument diagramDocument = xwiki.getDocument(this.resolver.resolve((Object)(decodedReference = URLDecoder.decode(documentReference, StandardCharsets.UTF_8)), new Object[0]), context);
        if (!this.documentAccessBridge.exists(diagramDocument.getDocumentReference())) {
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        if (!this.authorization.hasAccess(Right.EDIT, (EntityReference)diagramDocument.getDocumentReference())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        XWikiDocument clonedDiagramDocument = diagramDocument.clone();
        this.removeAttachments(clonedDiagramDocument, ".png");
        this.removeAttachments(clonedDiagramDocument, ".svg");
        xwiki.saveDocument(clonedDiagramDocument, "Clean old diagram attachments", false, context);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    private void removeAttachments(XWikiDocument document, String extension) {
        XWikiAttachment attachment;
        int count = 0;
        while ((attachment = document.getAttachment(this.getFileName(count, extension))) != null) {
            document.removeAttachment(attachment);
            ++count;
        }
    }

    private String getFileName(int index, String suffix) {
        if (index == 0) {
            return String.format("%s%s", PREFIX, suffix);
        }
        return String.format("%s%d%s", PREFIX, index + 1, suffix);
    }
}

