/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.diagram.internal.handlers;

import com.xwiki.diagram.internal.handlers.DiagramContentHandler;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.solr.common.SolrInputDocument;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component(roles={LinkRegistry.class})
@Singleton
public class LinkRegistry {
    private static final String ENTITY_PREFIX = "entity:";
    @Inject
    private DiagramContentHandler diagramContentHandler;
    @Inject
    @Named(value="withtype/withparameters")
    private EntityReferenceSerializer<String> entitySerializer;

    public boolean registerBacklinks(SolrInputDocument solrDocument, List<DocumentReference> references) {
        HashSet<String> links = new HashSet<String>(references.size());
        HashSet<String> extenedLinks = new HashSet<String>(references.size());
        boolean updated = false;
        for (DocumentReference reference : references) {
            EntityReference entityReference = new EntityReference(reference.getName(), reference.getType(), reference.getParent());
            String serializedEntity = (String)this.entitySerializer.serialize(entityReference, new Object[0]);
            boolean alreadyExists = solrDocument.get((Object)"links") != null && solrDocument.get((Object)"links").getValues().contains(serializedEntity);
            if (alreadyExists) continue;
            links.add(serializedEntity);
            extenedLinks.add(serializedEntity);
            this.extendLink(entityReference, extenedLinks);
            updated = true;
        }
        for (String link : links) {
            solrDocument.addField("links", (Object)link);
        }
        for (String linkExtended : extenedLinks) {
            solrDocument.addField("links_extended", (Object)linkExtended);
        }
        return updated;
    }

    private String serialize(EntityReference reference) {
        return ENTITY_PREFIX + (String)this.entitySerializer.serialize(reference, new Object[0]);
    }

    private void extendLink(EntityReference reference, Set<String> linksExtended) {
        EntityReference parent;
        EntityReference entityReference = parent = reference.getParameters().isEmpty() ? reference : new EntityReference(reference.getName(), reference.getType(), reference.getParent(), null);
        while (parent != null) {
            linksExtended.add(this.serialize(parent));
            parent = parent.getParent();
        }
    }
}

