/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.diagram.internal.handlers;

import com.xwiki.diagram.internal.handlers.DiagramLinkHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;

@Component(roles={GetDiagramLinksHandler.class})
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class GetDiagramLinksHandler
extends DefaultHandler {
    private static final String LINK = "link";
    private static final String LABEL = "label";
    @Inject
    private DiagramLinkHandler linkHandler;
    @Inject
    @Named(value="explicit")
    private DocumentReferenceResolver<String> resolver;
    private List<String> linkedPages = new ArrayList<String>();

    @Override
    public void startElement(String uri, String key, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("UserObject")) {
            if (attributes.getValue(LINK) != null) {
                this.linkedPages.add(this.linkHandler.getUserObjectNodeLink(attributes.getValue(LINK)));
            }
            if (attributes.getValue(LABEL) != null && attributes.getValue(LABEL).contains("href")) {
                this.linkedPages.addAll(this.linkHandler.getMxCellNodeLinks(attributes.getValue(LABEL)));
            }
        } else if (qName.equalsIgnoreCase("mxCell")) {
            this.linkedPages.addAll(this.linkHandler.getMxCellNodeLinks(attributes.getValue("value")));
        }
    }

    public List<DocumentReference> getLinkedPages(DocumentReference diagramReference) {
        return this.linkedPages.stream().distinct().map(link -> this.resolver.resolve(link, new Object[]{diagramReference})).collect(Collectors.toList());
    }
}

