/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.diagram.internal.handlers;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xwiki.diagram.internal.handlers.LinkRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.solr.common.SolrInputDocument;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.validation.EntityNameValidationConfiguration;
import org.xwiki.model.validation.EntityNameValidationManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.MacroBlockMatcher;
import org.xwiki.search.solr.SolrEntityMetadataExtractor;

@Component
@Named(value="macrodiagram")
@Singleton
public class DiagramMacroSolrMetadataExtractor
implements SolrEntityMetadataExtractor<XWikiDocument> {
    private static final String REFERENCE = "reference";
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    @Named(value="explicit")
    private DocumentReferenceResolver<String> explicitDocumentReferenceResolver;
    @Inject
    private LinkRegistry linkRegistry;
    @Inject
    private EntityNameValidationManager entityNameValidationManager;
    @Inject
    private EntityNameValidationConfiguration entityNameValidationConfiguration;
    @Inject
    private Logger logger;

    public boolean extract(XWikiDocument document, SolrInputDocument solrDocument) {
        XDOM xdom = document.getXDOM();
        List macroBlocks = xdom.getBlocks((BlockMatcher)new MacroBlockMatcher("diagram"), Block.Axes.CHILD);
        if (macroBlocks != null && !macroBlocks.isEmpty() && !this.updateMacroReference(document, xdom, macroBlocks)) {
            ArrayList<DocumentReference> macroReferences = new ArrayList<DocumentReference>();
            for (Block macroBlock : macroBlocks) {
                DocumentReference macroReference = this.explicitDocumentReferenceResolver.resolve((Object)macroBlock.getParameter(REFERENCE), new Object[]{document.getDocumentReference()});
                macroReferences.add(macroReference);
            }
            return this.linkRegistry.registerBacklinks(solrDocument, macroReferences);
        }
        return false;
    }

    private boolean updateMacroReference(XWikiDocument document, XDOM xdom, List<Block> macroBlocks) {
        try {
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            boolean modified = false;
            for (Block macroBlock : macroBlocks) {
                boolean isValid;
                String referenceName = macroBlock.getParameter(REFERENCE) != null ? macroBlock.getParameter(REFERENCE) : "Diagram";
                DocumentReference macroReference = this.explicitDocumentReferenceResolver.resolve((Object)referenceName, new Object[]{document.getDocumentReference()});
                boolean diagramAlreadyExists = context.getWiki().exists(macroReference, context);
                if (diagramAlreadyExists || (isValid = this.isValid(referenceName))) continue;
                String transformedName = this.transformName(referenceName);
                this.logger.debug("The reference [{}] was updated to [{}] to respect the current name strategy. Document: [{}]", new Object[]{referenceName, transformedName, document.getDocumentReference()});
                macroBlock.setParameter(REFERENCE, transformedName);
                modified = true;
            }
            if (modified) {
                document.setContent(xdom);
                context.getWiki().saveDocument(document, "Updated diagram macro references to respect the name strategy.", context);
                return modified;
            }
        }
        catch (XWikiException e) {
            this.logger.error("Failed to update diagram macro references of [{}] to respect the naming strategy.", (Object)document, (Object)e);
            return false;
        }
        return false;
    }

    private String transformName(String name) {
        if (this.entityNameValidationConfiguration.useTransformation() && this.entityNameValidationManager.getEntityReferenceNameStrategy() != null) {
            return this.entityNameValidationManager.getEntityReferenceNameStrategy().transform(name);
        }
        return name;
    }

    private boolean isValid(String name) {
        if (this.entityNameValidationConfiguration.useValidation() && this.entityNameValidationManager.getEntityReferenceNameStrategy() != null) {
            return this.entityNameValidationManager.getEntityReferenceNameStrategy().isValid(name);
        }
        return true;
    }
}

