/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.diagram.internal.handlers;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.xml.html.HTMLCleaner;

@Component(roles={DiagramLinkHandler.class})
@Singleton
public class DiagramLinkHandler {
    public static final String USEROBJECT = "UserObject";
    public static final String MXCELL = "mxCell";
    public static final String LINK = "link";
    public static final String LABEL = "label";
    private static final String HREF = "href";
    private static final String CUSTOM_LINK_PREFIX = "data:xwiki/reference,";
    @Inject
    private HTMLCleaner defaultHTMLCleaner;
    @Inject
    private Logger logger;

    private String getCustomLinkFromResourceReference(String resourceReference) {
        return "data:xwiki/reference,doc:" + resourceReference;
    }

    private String getResourceReferenceFromCustomLink(String href) {
        String resourceReference = href.substring(CUSTOM_LINK_PREFIX.length());
        Integer typeSeparatorIndex = resourceReference.indexOf(":");
        return resourceReference.substring(typeSeparatorIndex + 1);
    }

    private Boolean isXWikiCustomLink(String href) {
        return href.substring(0, CUSTOM_LINK_PREFIX.length()).contentEquals(CUSTOM_LINK_PREFIX);
    }

    public void updateUserObjectNode(Node node, DocumentReference newDocumentRef, DocumentReference oldDocumentRef) throws IOException, ParserConfigurationException, SAXException {
        if (node.hasChildNodes()) {
            String oldSource;
            Node linkNode = node.getAttributes().getNamedItem(LINK);
            if (linkNode != null && this.isXWikiCustomLink(oldSource = linkNode.getNodeValue()).booleanValue() && oldDocumentRef.toString().equals(this.getResourceReferenceFromCustomLink(oldSource))) {
                String newSource = this.getCustomLinkFromResourceReference(newDocumentRef.toString());
                linkNode.setTextContent(newSource);
            }
            if ((linkNode = node.getAttributes().getNamedItem(LABEL)) != null) {
                this.updateEmbeddedLinks(linkNode, newDocumentRef, oldDocumentRef);
            }
        }
    }

    public void updateMxCellNode(Node node, DocumentReference newDocumentRef, DocumentReference oldDocumentRef) throws ParserConfigurationException, SAXException, IOException {
        if (node.hasChildNodes()) {
            Node linkNode = node.getAttributes().getNamedItem("value");
            if (linkNode == null) {
                return;
            }
            this.updateEmbeddedLinks(linkNode, newDocumentRef, oldDocumentRef);
        }
    }

    private void updateEmbeddedLinks(Node linkNode, DocumentReference newDocumentRef, DocumentReference oldDocumentRef) throws IOException, ParserConfigurationException, SAXException {
        String value = linkNode.getNodeValue();
        if (value.indexOf(HREF) == -1) {
            return;
        }
        for (String oldSource : this.getLinksFromEmbeddedNode(value)) {
            if (oldSource == null || !this.isXWikiCustomLink(oldSource).booleanValue() || !oldDocumentRef.toString().equals(this.getResourceReferenceFromCustomLink(oldSource))) continue;
            String newSource = this.getCustomLinkFromResourceReference(newDocumentRef.toString());
            linkNode.setNodeValue(value.replace(oldSource, newSource));
        }
    }

    public String getUserObjectNodeLink(String link) {
        if (link == null || !this.isXWikiCustomLink(link).booleanValue()) {
            return null;
        }
        return this.getResourceReferenceFromCustomLink(link);
    }

    public List<String> getMxCellNodeLinks(String value) {
        List<String> links = new ArrayList<String>();
        if (value == null || value.indexOf(HREF) == -1) {
            return links;
        }
        try {
            links = this.getLinksFromEmbeddedNode(value);
            links = links.stream().filter(Objects::nonNull).filter(this::isXWikiCustomLink).map(link -> this.getResourceReferenceFromCustomLink((String)link)).collect(Collectors.toList());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            this.logger.warn("Failed while parsing a mxCell node", (Throwable)e);
        }
        return links;
    }

    private List<String> getLinksFromEmbeddedNode(String value) throws SAXException, IOException, ParserConfigurationException {
        ArrayList<String> hrefValues = new ArrayList<String>();
        Document doc = this.defaultHTMLCleaner.clean((Reader)new StringReader(value));
        NodeList nodes = doc.getElementsByTagName("a");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element node = (Element)nodes.item(i);
            hrefValues.add(node.getAttribute(HREF));
        }
        return hrefValues;
    }
}

