/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.diagram.internal.handlers;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xwiki.diagram.internal.handlers.DiagramLinkHandler;
import com.xwiki.diagram.internal.handlers.GetDiagramLinksHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.xml.XMLUtils;

@Component(roles={DiagramContentHandler.class})
@Singleton
public class DiagramContentHandler {
    public static final String VIEW_ACTION = "view";
    public static final LocalDocumentReference DIAGRAM_CLASS = new LocalDocumentReference("Diagram", "DiagramClass");
    @Inject
    private Provider<GetDiagramLinksHandler> getDiagramLinksHandlerProvider;
    @Inject
    private DiagramLinkHandler linkHandler;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Logger logger;

    public void updateAttachment(XWikiDocument backlinkDoc, DocumentReference oldDocRef, DocumentReference newDocRef) throws XWikiException, IOException {
        XWikiAttachment attachment = backlinkDoc.getAttachment("diagram.svg");
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        if (attachment != null) {
            backlinkDoc.setAttachment(this.getUpdatedAttachment(attachment, oldDocRef, newDocRef));
            context.getWiki().saveDocument(backlinkDoc, "Updated attachment after page rename", context);
        }
    }

    private XWikiAttachment getUpdatedAttachment(XWikiAttachment attachment, DocumentReference oldDocRef, DocumentReference newDocRef) throws XWikiException, IOException {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        XWikiDocument oldDoc = context.getWiki().getDocument(oldDocRef, context);
        XWikiDocument newDoc = context.getWiki().getDocument(newDocRef, context);
        String attachmentContent = IOUtils.toString((InputStream)attachment.getContentInputStream(context), (String)"UTF-8");
        String regex = "\"%s\"";
        String oldAbsoluteURL = String.format(regex, oldDoc.getExternalURL(VIEW_ACTION, context));
        String newAbsoluteURL = String.format(regex, newDoc.getExternalURL(VIEW_ACTION, context));
        String oldURL = String.format(regex, oldDoc.getURL(VIEW_ACTION, context));
        String newURL = String.format(regex, newDoc.getURL(VIEW_ACTION, context));
        String newContent = attachmentContent.replaceAll(oldAbsoluteURL, newAbsoluteURL).replaceAll(oldURL, newURL);
        attachment.setContent((InputStream)new ByteArrayInputStream(newContent.getBytes()));
        return attachment;
    }

    public void updateDiagramContent(XWikiDocument backlinkDoc, DocumentReference originalDocRef, DocumentReference currentDocRef, XWikiContext context) throws ParserConfigurationException, SAXException, IOException, XWikiException {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(backlinkDoc.getContent().getBytes()));
        NodeList userObjectList = document.getElementsByTagName("UserObject");
        for (int i = 0; i < userObjectList.getLength(); ++i) {
            this.linkHandler.updateUserObjectNode(userObjectList.item(i), currentDocRef, originalDocRef);
        }
        NodeList mxCellList = document.getElementsByTagName("mxCell");
        for (int i = 0; i < mxCellList.getLength(); ++i) {
            this.linkHandler.updateMxCellNode(mxCellList.item(i), currentDocRef, originalDocRef);
        }
        backlinkDoc.setContent(XMLUtils.serialize((Node)document));
        context.getWiki().saveDocument(backlinkDoc, "Updated diagram after page rename", context);
    }

    public List<DocumentReference> getLinkedPages(String content, DocumentReference diagramReference) {
        try {
            GetDiagramLinksHandler getDiagramLinksHandler = (GetDiagramLinksHandler)this.getDiagramLinksHandlerProvider.get();
            SAXParserFactory.newInstance().newSAXParser().parse((InputStream)new ByteArrayInputStream(content.getBytes()), (DefaultHandler)getDiagramLinksHandler);
            return getDiagramLinksHandler.getLinkedPages(diagramReference);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            this.logger.warn("Failed while getting diagram linked pages", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

