/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.diagram.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xwiki.diagram.internal.AbstractDiagramMigration;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;

@Component(roles={StoreSVGAsAttachmentMigration.class})
@Singleton
public class StoreSVGAsAttachmentMigration
extends AbstractDiagramMigration {
    private static final LocalDocumentReference DIAGRAM_CLASS_REFERENCE = new LocalDocumentReference("Diagram", "DiagramClass");
    private static final String DIAGRAM_ATTACHMENT_NAME = "diagram.svg";
    @Inject
    @Named(value="document")
    private QueryFilter documentQueryFilter;

    @Override
    protected Collection<DocumentReference> getDiagramsToMigrate(String wiki) throws QueryException {
        String statement = ", BaseObject as obj, LargeStringProperty as prop where doc.fullName = obj.name and obj.className = 'Diagram.DiagramClass' and obj.id = prop.id.id and prop.id.name = 'svg' and doc.fullName <> 'Diagram.DiagramTemplate'";
        Query query = this.queryManager.createQuery(statement, "hql");
        return query.setWiki(wiki).addFilter(this.documentQueryFilter).execute();
    }

    @Override
    protected boolean migrate(DocumentReference diagramReference) {
        try {
            BaseObject diagramObject;
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            XWikiDocument document = xcontext.getWiki().getDocument(diagramReference, xcontext);
            XWikiAttachment attachment = document.getAttachment(DIAGRAM_ATTACHMENT_NAME);
            if (attachment == null && (diagramObject = document.getXObject((EntityReference)DIAGRAM_CLASS_REFERENCE)) != null) {
                String svg = diagramObject.getLargeStringValue("svg");
                document.addAttachment(DIAGRAM_ATTACHMENT_NAME, (InputStream)new ByteArrayInputStream(svg.getBytes("UTF-8")), xcontext);
                this.synchronizeObject(diagramObject, xcontext);
                xcontext.getWiki().saveDocument(document, "Moved diagram SVG to attachments", xcontext);
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to migrate diagram [{}].", (Object)diagramReference, (Object)e);
        }
        return false;
    }

    private void synchronizeObject(BaseObject object, XWikiContext xcontext) {
        for (BaseProperty property : object.getXClass(xcontext).getDeprecatedObjectProperties(object)) {
            object.removeField(property.getName());
        }
    }
}

