/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.diagram.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xwiki.diagram.internal.AbstractDiagramRunnable;
import com.xwiki.diagram.internal.DiagramLinksRunnable;
import com.xwiki.diagram.internal.DiagramMacroRunnable;
import com.xwiki.diagram.internal.DiagramQueueEntry;
import com.xwiki.diagram.internal.handlers.DiagramContentHandler;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Disposable;
import org.xwiki.job.Job;
import org.xwiki.job.JobContext;
import org.xwiki.job.event.JobStartedEvent;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.ObservationContext;
import org.xwiki.observation.event.BeginEvent;
import org.xwiki.observation.event.Event;

@Component
@Named(value="PageRenameEventListener")
@Singleton
public class PageRenameListener
extends AbstractEventListener
implements Disposable {
    protected static final String ROLE_HINT = "PageRenameEventListener";
    public Thread diagramLinksThread;
    public Thread diagramMacroThread;
    @Inject
    protected ObservationContext observationContext;
    @Inject
    protected JobContext jobContext;
    @Inject
    protected ComponentManager componentManager;
    @Inject
    private Logger logger;
    @Inject
    private DiagramLinksRunnable diagramLinksRunnable;
    @Inject
    private DiagramMacroRunnable diagramMacroRunnable;

    public PageRenameListener() {
        super(ROLE_HINT, new Event[]{new DocumentCreatedEvent()});
    }

    public void onEvent(Event event, Object source, Object data) {
        if (this.diagramLinksThread == null || this.diagramMacroThread == null) {
            this.startThreads();
        }
        if (this.observationContext.isIn((BeginEvent)new JobStartedEvent("refactoring/rename"))) {
            Job job = this.jobContext.getCurrentJob();
            DocumentReference destinationRef = (DocumentReference)job.getRequest().getProperty("destination");
            List references = (List)job.getRequest().getProperty("entityReferences");
            if (references != null && references.size() > 0) {
                XWikiDocument currentDoc = (XWikiDocument)source;
                DocumentReference originalDocRef = (DocumentReference)references.get(0);
                DocumentReference currentDocRef = currentDoc.getDocumentReference();
                if (destinationRef.equals((Object)currentDocRef)) {
                    this.startContentUpdating((XWikiContext)data, currentDoc, originalDocRef);
                }
            }
        }
    }

    public void startContentUpdating(XWikiContext context, XWikiDocument currentDoc, DocumentReference originalDocRef) {
        DiagramQueueEntry queueEntry = new DiagramQueueEntry(originalDocRef, currentDoc.getDocumentReference());
        if (currentDoc.getXObject((EntityReference)DiagramContentHandler.DIAGRAM_CLASS) != null) {
            this.diagramMacroRunnable.addToQueue(queueEntry);
        }
        try {
            if (!context.getWiki().getDocument(originalDocRef, context).getBackLinkedReferences(context).isEmpty()) {
                this.diagramLinksRunnable.addToQueue(queueEntry);
            }
        }
        catch (XWikiException e) {
            this.logger.warn("Error when getting backlinks of renamed document");
        }
    }

    public synchronized void startThreads() {
        if (this.diagramLinksThread == null) {
            this.diagramLinksThread = this.startThread(this.diagramLinksRunnable, "Update Diagram Links Thread");
        }
        if (this.diagramMacroThread == null) {
            this.diagramMacroThread = this.startThread(this.diagramMacroRunnable, "Update Diagram Macro Thread");
        }
    }

    public Thread startThread(AbstractDiagramRunnable diagramRunnable, String threadName) {
        Thread diagramThread = new Thread((Runnable)((Object)diagramRunnable));
        diagramThread.setName(threadName);
        diagramThread.setDaemon(true);
        diagramThread.start();
        return diagramThread;
    }

    public void stopThread(Thread diagramThread, AbstractDiagramRunnable diagramRunnable) throws InterruptedException {
        if (diagramThread != null) {
            diagramRunnable.addToQueue(AbstractDiagramRunnable.STOP_RUNNABLE_ENTRY);
            diagramThread.join();
        }
    }

    public void dispose() throws ComponentLifecycleException {
        try {
            this.stopThread(this.diagramLinksThread, this.diagramLinksRunnable);
            this.stopThread(this.diagramMacroThread, this.diagramMacroRunnable);
        }
        catch (InterruptedException e) {
            this.logger.warn("Diagram backlinks update thread interruped", (Throwable)e);
        }
    }
}

