/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.diagram.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xwiki.diagram.internal.AbstractDiagramMigration;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;

@Component(roles={DrawIOImagePathMigration.class})
@Singleton
public class DrawIOImagePathMigration
extends AbstractDiagramMigration {
    private static final Pattern IMAGE_WEBJAR_PATH = Pattern.compile("image=[\\w/%.-]*\\/img/");
    private static final String IMAGE_WAR_PATH = "image=img/";
    @Inject
    @Named(value="document")
    private QueryFilter documentQueryFilter;

    @Override
    protected Collection<DocumentReference> getDiagramsToMigrate(String wiki) throws QueryException {
        String statement = ", BaseObject as obj where obj.name = doc.fullName and obj.className = 'Diagram.DiagramClass' and doc.fullName <> 'Diagram.DiagramTemplate' and (doc.content like '%/webjars/%/draw.io/%' or doc.content like '%image=/img/%')";
        Query query = this.queryManager.createQuery(statement, "hql");
        return query.setWiki(wiki).addFilter(this.documentQueryFilter).execute();
    }

    @Override
    protected boolean migrate(DocumentReference diagramReference) {
        try {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            XWikiDocument document = xcontext.getWiki().getDocument(diagramReference, xcontext);
            String content = IMAGE_WEBJAR_PATH.matcher(document.getContent()).replaceAll(IMAGE_WAR_PATH);
            content = content.replace("image=/img/", IMAGE_WAR_PATH);
            document.setContent(content);
            xcontext.getWiki().saveDocument(document, "Fixed draw.io image paths", xcontext);
            return true;
        }
        catch (Exception e) {
            this.logger.error("Failed to migrate diagram [{}].", (Object)diagramReference, (Object)e);
            return false;
        }
    }
}

