/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.diagram.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xwiki.diagram.internal.AbstractDiagramRunnable;
import com.xwiki.diagram.internal.DiagramQueueEntry;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.MacroBlockMatcher;

@Component(roles={DiagramMacroRunnable.class})
@Singleton
public class DiagramMacroRunnable
extends AbstractDiagramRunnable {
    private static final String MACRO_REFERENCE_PARAMETER = "reference";
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    @Named(value="compact")
    private EntityReferenceSerializer<String> compactEntityReferenceSerializer;
    @Inject
    private Logger logger;

    public void runInternal() {
        DiagramQueueEntry queueEntry;
        while (!Thread.interrupted() && (queueEntry = this.getNextDiagramQueueEntry()) != STOP_RUNNABLE_ENTRY) {
            XWikiContext xcontext = (XWikiContext)this.contextProvider.get();
            DocumentReference originalDocRef = queueEntry.originalDocRef;
            DocumentReference currentDocRef = queueEntry.currentDocRef;
            try {
                List backlinks = xcontext.getWiki().getDocument(originalDocRef, xcontext).getBackLinkedReferences(xcontext);
                for (DocumentReference backlinkDocRef : backlinks) {
                    XWikiDocument backlinkDoc = xcontext.getWiki().getDocument(backlinkDocRef, xcontext).clone();
                    this.updateDiagramMacrosReferences(backlinkDoc, currentDocRef, originalDocRef, xcontext);
                }
            }
            catch (XWikiException e) {
                this.logger.warn("Update diagram macro reference parameter thread interrupted", (Throwable)e);
            }
        }
    }

    public void updateDiagramMacrosReferences(XWikiDocument document, DocumentReference newReference, DocumentReference oldReference, XWikiContext xcontext) throws XWikiException {
        XDOM backlinkDocXDOM = document.getXDOM();
        List macroBlocks = backlinkDocXDOM.getBlocks((BlockMatcher)new MacroBlockMatcher("diagram"), Block.Axes.CHILD);
        String newReferenceString = (String)this.compactEntityReferenceSerializer.serialize((EntityReference)newReference, new Object[]{document.getDocumentReference()});
        String oldReferenceString = (String)this.compactEntityReferenceSerializer.serialize((EntityReference)oldReference, new Object[]{document.getDocumentReference()});
        Boolean modified = false;
        for (Block macroBlock : macroBlocks) {
            String macroReference = macroBlock.getParameter(MACRO_REFERENCE_PARAMETER);
            if (macroReference.equals(newReferenceString) || !macroReference.equals(oldReferenceString)) continue;
            macroBlock.setParameter(MACRO_REFERENCE_PARAMETER, newReferenceString);
            modified = true;
        }
        if (modified.booleanValue()) {
            document.setContent(backlinkDocXDOM);
            xcontext.getWiki().saveDocument(document, "Updated diagram macros references after diagram page rename", xcontext);
        }
    }
}

