/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.diagram.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xwiki.diagram.internal.AbstractDiagramRunnable;
import com.xwiki.diagram.internal.DiagramQueueEntry;
import com.xwiki.diagram.internal.handlers.DiagramContentHandler;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;

@Component(roles={DiagramLinksRunnable.class})
@Singleton
public class DiagramLinksRunnable
extends AbstractDiagramRunnable {
    @Inject
    private Logger logger;
    @Inject
    private DiagramContentHandler contentHandler;
    @Inject
    private Provider<XWikiContext> contextProvider;

    public void runInternal() {
        DiagramQueueEntry queueEntry;
        while (!Thread.interrupted() && (queueEntry = this.getNextDiagramQueueEntry()) != STOP_RUNNABLE_ENTRY) {
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            DocumentReference originalDocRef = queueEntry.originalDocRef;
            DocumentReference currentDocRef = queueEntry.currentDocRef;
            try {
                List backlinks = context.getWiki().getDocument(originalDocRef, context).getBackLinkedReferences(context);
                for (DocumentReference backlinkRef : backlinks) {
                    XWikiDocument backlinkDoc = context.getWiki().getDocument(backlinkRef, context).clone();
                    if (backlinkDoc.getXObject((EntityReference)DiagramContentHandler.DIAGRAM_CLASS) == null) continue;
                    this.contentHandler.updateDiagramContent(backlinkDoc, originalDocRef, currentDocRef, context);
                    this.contentHandler.updateAttachment(backlinkDoc, originalDocRef, currentDocRef);
                }
            }
            catch (Exception e) {
                this.logger.warn("Update diagram backlinks thread interrupted", (Throwable)e);
            }
        }
    }
}

