/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.diagram.internal;

import com.mxgraph.io.gliffy.importer.GliffyDiagramConverterMultiplePages;
import com.mxgraph.io.gliffy.importer.OldGliffyDiagramConverter;
import com.mxgraph.io.mxCodec;
import com.mxgraph.io.mxGraphMlCodec;
import com.mxgraph.online.gliffy.OpenServletUtils;
import com.mxgraph.util.mxXmlUtils;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphHeadless;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xwiki.component.annotation.Component;

@Component(roles={DiagramImporter.class})
@Singleton
public class DiagramImporter {
    private static String gliffyRegex = "(?s).*\"contentType\":\\s*\"application/gliffy\\+json\".*";
    private static String oldGliffyRegex = "(?s).*\"stage\":.*";
    private static String graphMlRegex = "(?s).*<graphml xmlns=\".*";
    @Inject
    private Logger logger;

    public String importDiagram(String diagram, String fileName) {
        String xml = null;
        if (fileName != null && fileName.toLowerCase().endsWith(".png")) {
            try {
                xml = this.extractXMLFromPNG(diagram.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else if (diagram.matches(graphMlRegex)) {
            mxGraphHeadless graph = new mxGraphHeadless();
            mxGraphMlCodec.decode((Document)mxXmlUtils.parseXml((String)diagram), (mxGraph)graph);
            xml = mxXmlUtils.getXml((Node)new mxCodec().encode((Object)graph.getModel()));
        } else if (diagram.matches(gliffyRegex)) {
            try {
                if (diagram.matches(oldGliffyRegex)) {
                    OldGliffyDiagramConverter converter = new OldGliffyDiagramConverter(diagram);
                    xml = converter.getGraphXml();
                } else {
                    GliffyDiagramConverterMultiplePages converter = new GliffyDiagramConverterMultiplePages(diagram);
                    xml = converter.getGraphXml();
                }
            }
            catch (Exception e) {
                this.logger.error("Error while converting a gliffy diagram to drawio.", (Throwable)e);
            }
        }
        return xml;
    }

    private String extractXMLFromPNG(byte[] data) {
        Map textChunks = OpenServletUtils.decodeCompressedText((InputStream)new ByteArrayInputStream(data));
        return textChunks != null ? (String)textChunks.get("mxGraphModel") : null;
    }
}

