/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.diagram.internal;

import com.xpn.xwiki.XWikiContext;
import com.xwiki.diagram.internal.DrawIOImagePathMigration;
import com.xwiki.diagram.internal.StoreSVGAsAttachmentMigration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.manager.NamespacedComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.extension.event.ExtensionEvent;
import org.xwiki.extension.event.ExtensionInstalledEvent;
import org.xwiki.extension.event.ExtensionUpgradedEvent;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Named(value="DiagramApplicationListener")
@Singleton
public class DiagramApplicationListener
extends AbstractEventListener
implements Initializable {
    protected static final String ROLE_HINT = "DiagramApplicationListener";
    private static final String DIAGRAM_APPPLICATION_ID = "com.xwiki.diagram:application-diagram";
    @Inject
    private Logger logger;
    @Inject
    private StoreSVGAsAttachmentMigration svgMigrator;
    @Inject
    private DrawIOImagePathMigration imagePathMigrator;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private ComponentManager componentManager;

    public DiagramApplicationListener() {
        super(ROLE_HINT, Arrays.asList(new ExtensionUpgradedEvent(DIAGRAM_APPPLICATION_ID), new ExtensionInstalledEvent()));
    }

    public void initialize() {
        if (this.contextProvider.get() != null) {
            boolean hasNamespace = this.componentManager instanceof NamespacedComponentManager;
            this.getTargetWikis(hasNamespace ? ((NamespacedComponentManager)this.componentManager).getNamespace() : null).forEach(this::migrate);
        }
    }

    public void onEvent(Event event, Object source, Object data) {
        if (event instanceof ExtensionUpgradedEvent || DiagramApplicationListener.isDiagramInstallEvent(event)) {
            ExtensionEvent extensionEvent = (ExtensionEvent)event;
            this.getTargetWikis(extensionEvent.hasNamespace() ? extensionEvent.getNamespace() : null).forEach(this::migrate);
        }
    }

    private static boolean isDiagramInstallEvent(Event event) {
        return event instanceof ExtensionInstalledEvent && DIAGRAM_APPPLICATION_ID.equals(((ExtensionEvent)event).getExtensionId().getId());
    }

    private Collection<String> getTargetWikis(String namespace) {
        if (namespace != null && namespace.startsWith("wiki:")) {
            return Collections.singleton(namespace.substring(5));
        }
        try {
            return this.wikiDescriptorManager.getAllIds();
        }
        catch (WikiManagerException e) {
            this.logger.error("Failed to get the list of wikis.", (Throwable)e);
            return Collections.emptySet();
        }
    }

    private void migrate(String wiki) {
        this.svgMigrator.migrate(wiki);
        this.imagePathMigrator.migrate(wiki);
    }
}

