/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.diagram.internal;

import com.xpn.xwiki.util.AbstractXWikiRunnable;
import com.xwiki.diagram.internal.DiagramQueueEntry;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.inject.Inject;
import org.slf4j.Logger;

public abstract class AbstractDiagramRunnable
extends AbstractXWikiRunnable {
    public static final DiagramQueueEntry STOP_RUNNABLE_ENTRY = new DiagramQueueEntry(null, null);
    private final BlockingQueue<DiagramQueueEntry> diagramsQueue = new LinkedBlockingQueue<DiagramQueueEntry>();
    @Inject
    private Logger logger;

    public void addToQueue(DiagramQueueEntry queueEntry) {
        this.diagramsQueue.add(queueEntry);
    }

    public DiagramQueueEntry getNextDiagramQueueEntry() {
        DiagramQueueEntry queueEntry;
        try {
            queueEntry = this.diagramsQueue.take();
        }
        catch (InterruptedException e) {
            this.logger.warn("Diagrams update thread has been interrupted", (Throwable)e);
            queueEntry = STOP_RUNNABLE_ENTRY;
        }
        if (queueEntry == STOP_RUNNABLE_ENTRY) {
            this.diagramsQueue.clear();
        }
        return queueEntry;
    }
}

