/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.diagram.internal;

import com.xpn.xwiki.XWikiContext;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;

public abstract class AbstractDiagramMigration {
    @Inject
    protected Logger logger;
    @Inject
    protected QueryManager queryManager;
    @Inject
    protected DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    protected Provider<XWikiContext> xcontextProvider;

    public Collection<DocumentReference> migrate(String wiki) {
        try {
            return this.getDiagramsToMigrate(wiki).stream().filter(this::migrate).collect(Collectors.toList());
        }
        catch (QueryException e) {
            this.logger.error("Failed to get the list of diagrams to migrate.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    protected abstract Collection<DocumentReference> getDiagramsToMigrate(String var1) throws QueryException;

    protected abstract boolean migrate(DocumentReference var1);
}

