/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.date.internal.macro;

import com.xwiki.date.DateMacroConfiguration;
import com.xwiki.date.macro.DateMacroParameters;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.skinx.SkinExtension;

@Component
@Named(value="date")
@Singleton
public class DateMacro
extends AbstractMacro<DateMacroParameters> {
    public static final String MACRO_NAME = "date";
    public static final String SKIN_RESOURCES_DOCUMENT_REFERENCE = "DateMacro.Code.SkinExtension";
    @Inject
    private DateMacroConfiguration configuration;
    @Inject
    @Named(value="ssx")
    private SkinExtension ssx;

    public DateMacro() {
        super("Date", "Insert a date that will be displayed nicely.", DateMacroParameters.class);
        this.setDefaultCategories(Collections.singleton("Content"));
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public List<Block> execute(DateMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        Date paramDate;
        this.ssx.use(SKIN_RESOURCES_DOCUMENT_REFERENCE);
        String format = this.configuration.getStorageDateFormat();
        try {
            if (!StringUtils.isEmpty((CharSequence)parameters.getFormat())) {
                format = parameters.getFormat();
            }
            paramDate = new SimpleDateFormat(format).parse(parameters.getValue());
        }
        catch (ParseException e) {
            throw new MacroExecutionException(String.format("Failed to parse the given date, expected format [%s]!", format));
        }
        String displayFormat = StringUtils.isEmpty((CharSequence)parameters.getDisplayFormat()) ? this.configuration.getDisplayDateFormat() : parameters.getDisplayFormat();
        String displayDate = new SimpleDateFormat(displayFormat).format(paramDate);
        FormatBlock returnBlock = context.isInline() ? new FormatBlock(Collections.singletonList(new WordBlock(displayDate)), Format.NONE) : new GroupBlock(Collections.singletonList(new WordBlock(displayDate)));
        returnBlock.setParameters(Collections.singletonMap("class", "xwiki-date"));
        return Collections.singletonList(returnBlock);
    }
}

