/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.date.internal;

import com.xwiki.date.DateMacroConfiguration;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.stability.Unstable;

@Component
@Singleton
@Unstable
public class DefaultDateConfiguration
implements DateMacroConfiguration {
    private static final String STORAGE_FORMAT_KEY = "storageDateFormat";
    private static final String DISPLAY_FORMAT_KEY = "displayDateFormat";
    private static final String DEFAULT_DATE_FORMAT = "yyyy/MM/dd HH:mm";
    private static final String PROPERTIES_PREFIX = "datemacro.";
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource xwikiProperties;
    @Inject
    @Named(value="wiki")
    private ConfigurationSource preferencesConfiguration;
    @Inject
    @Named(value="datemacro")
    private ConfigurationSource configurationSource;

    public String getStorageDateFormat() {
        return this.getProperty(STORAGE_FORMAT_KEY, DEFAULT_DATE_FORMAT);
    }

    public String getDisplayDateFormat() {
        return this.getProperty(DISPLAY_FORMAT_KEY, (String)this.preferencesConfiguration.getProperty("dateformat", (Object)DEFAULT_DATE_FORMAT));
    }

    private <T> T getProperty(String key, T defaultValue) {
        if (this.configurationSource.containsKey(key)) {
            return (T)this.configurationSource.getProperty(key, defaultValue);
        }
        return (T)this.xwikiProperties.getProperty(PROPERTIES_PREFIX + key, defaultValue);
    }
}

