/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.test.po;

import com.xwiki.confluencepro.test.po.CreateBatchPage;
import com.xwiki.confluencepro.test.po.MigrationCreationPage;
import com.xwiki.confluencepro.test.po.MigrationRunningPage;
import java.io.File;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.xwiki.livedata.test.po.LiveDataElement;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.test.ui.XWikiWebDriver;
import org.xwiki.test.ui.po.ViewPage;

public class ConfluenceHomePage
extends ViewPage {
    public static ConfluenceHomePage goToPage() {
        DocumentReference reference = new DocumentReference("xwiki", "ConfluenceMigratorPro", "WebHome");
        ConfluenceHomePage.getUtil().gotoPage((EntityReference)reference);
        return new ConfluenceHomePage();
    }

    public LiveDataElement getPackageLiveTable() {
        return new LiveDataElement("confluencePackages");
    }

    public LiveDataElement getMigrationsLiveTable() {
        return new LiveDataElement("confluenceMigrations");
    }

    public String migrationStatus(int migrationIndex) {
        List statuses = this.getDriver().findElements(By.cssSelector((String)"#confluenceMigrations tbody tr td:nth-child(2)"));
        return ((WebElement)statuses.get(migrationIndex)).getText().trim();
    }

    public MigrationRunningPage getMigrationRunningPage(int migrationIndex) {
        List statuses = this.getDriver().findElements(By.cssSelector((String)"#confluenceMigrations tbody tr td:nth-child(1) a"));
        ((WebElement)statuses.get(migrationIndex)).click();
        return new MigrationRunningPage();
    }

    public MigrationCreationPage selectPackage(int number) {
        this.getPackageLiveTable().getTableLayout().findElementInRow(number, By.className((String)"startMigration")).click();
        return new MigrationCreationPage();
    }

    public void openHowToMigrateSubsection(String subsectionClass) {
        this.getDriver().setDriverImplicitWait();
        WebElement subsections = this.getDriver().findElement(By.cssSelector((String)(subsectionClass + " .cfmTitleIcon")));
        subsections.click();
    }

    public void selectMigrationOptions(String selector, String value) {
        this.getDriver().findElement(By.cssSelector((String)String.format("%s input[value=%s]", selector, value))).click();
    }

    public void openSection(String contentContainer) {
        this.getDriver().findElement(By.cssSelector((String)String.format("li[data-content-container=%s]", contentContainer))).click();
        this.loadingSection();
    }

    public boolean checkIfSectionWasLoaded(String sectionClass) {
        try {
            this.getDriver().findElement(By.cssSelector((String)sectionClass));
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    public CreateBatchPage createNewBatch() {
        this.getDriver().findElement(By.cssSelector((String)"#createNewBatchButton")).click();
        return new CreateBatchPage();
    }

    public void attachFiles(String testResourcePath, List<String> files) {
        WebElement input = this.getDriver().findElement(By.id((String)"confluenceUploadFile"));
        if (!input.isDisplayed()) {
            XWikiWebDriver js = this.getDriver();
            js.executeScript("arguments[0].classList.remove('hidden');", new Object[]{input});
        }
        for (String file : files) {
            input.clear();
            input.sendKeys(new CharSequence[]{this.getFileToUpload(testResourcePath, file).getAbsolutePath()});
            this.waitForNotificationSuccessMessage("Attachment uploaded: " + file);
        }
        this.getDriver().navigate().refresh();
    }

    public int countBatches() {
        return this.getDriver().findElements(By.cssSelector((String)"#confluenceMigratorProBatches table tbody tr")).size();
    }

    private void loadingSection() {
        this.getDriver().waitUntilCondition(ExpectedConditions.not((ExpectedCondition)ExpectedConditions.attributeContains((By)By.cssSelector((String)".confluence-pro-section-containers"), (String)"class", (String)"loading")));
    }

    private File getFileToUpload(String testResourcePath, String filename) {
        return new File(testResourcePath, "ConfluenceMigratorIT/" + filename);
    }
}

