/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.pro.internal.resolvers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.store.DatabaseProduct;
import com.xpn.xwiki.store.XWikiHibernateStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;

@Component(roles={LinkMappingStore.class})
@Singleton
public class LinkMappingStore
implements Initializable {
    private static final List<DatabaseProduct> DATABASES_SUPPORTING_BIGINT = List.of(DatabaseProduct.POSTGRESQL, DatabaseProduct.HSQLDB, DatabaseProduct.H2, DatabaseProduct.MYSQL, DatabaseProduct.DB2, DatabaseProduct.DERBY, DatabaseProduct.MSSQL);
    private static final TypeReference<Map<String, String>> LM_TYPE_REF = new TypeReference<Map<String, String>>(){};
    private static final String IDS_SUFFIX = ":ids";
    private static final String CREATE_TABLE = "create table if not exists %s (%s, reference VARCHAR(768))";
    private static final String TABLE_BY_TITLE = "confluencepro_linkmapping_by_title";
    private static final String TABLE_BY_ID = "confluencepro_linkmapping_by_id";
    private static final String DELETE_FROM = "delete from ";
    private static final String INSERT_INTO = "insert into ";
    private static final String SELECT_REFERENCE_FROM = "select reference from ";
    private static final String WHERE_PAGE_ID = " where pageId = ?";
    private static final String WHERE_SPACE_KEY_AND_PAGE_TITLE = " where spaceKey = ? and pageTitle = ?";
    private static final String DROP_TABLE = "drop table ";
    private static final String SELECT_1_FROM = "select 1 from ";
    private static final String LIMIT_1 = " limit 1";
    private static final String SPACES = "spaces";
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private Logger logger;
    @Inject
    private QueryManager queryManager;
    private boolean initialized;
    private boolean dontExist;
    private boolean needsConversion = true;

    public void initialize() {
        if (this.contextProvider.get() != null) {
            try {
                this.convertOldMappings();
            }
            catch (Exception e) {
                this.logger.error("Failed to convert old mappings. Link mapping issues may arise. ", (Throwable)e);
            }
        }
    }

    private boolean areTableAbsent() {
        boolean res;
        Session session = this.beginTransaction();
        try {
            res = this.areTableAbsent(session);
        }
        finally {
            this.endTransaction(false);
        }
        return res;
    }

    private boolean areTableAbsent(Session session) {
        if (this.dontExist) {
            return true;
        }
        if (this.initialized) {
            return false;
        }
        boolean found = session.createNativeQuery("select 1 from information_schema.tables where lower(table_name) = 'confluencepro_linkmapping_by_id' and lower(table_schema) in ('xwiki', 'app', 'public')").getResultStream().findFirst().isPresent();
        if (found) {
            this.initialized = true;
            return false;
        }
        this.dontExist = true;
        return true;
    }

    public Session beginTransaction() {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        try {
            XWikiHibernateStore store = XWiki.getMainXWiki((XWikiContext)context).getHibernateStore();
            if (store.beginTransaction(context)) {
                return store.getSession(context);
            }
        }
        catch (XWikiException e) {
            this.logger.error("Failed to begin a transaction", (Throwable)e);
        }
        return null;
    }

    public void endTransaction(boolean commit) {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        XWikiHibernateStore store = context.getWiki().getHibernateStore();
        store.endTransaction(context, commit);
    }

    private void createTableIfNotExists(Session session) {
        if (!this.areTableAbsent(session)) {
            return;
        }
        String sqlLong = this.getSQLLongType(((XWikiContext)this.contextProvider.get()).getWiki().getHibernateStore().getDatabaseProductName());
        session.createNativeQuery(String.format(CREATE_TABLE, TABLE_BY_ID, "pageId " + sqlLong + " not null unique")).executeUpdate();
        session.createNativeQuery(String.format(CREATE_TABLE, TABLE_BY_TITLE, "spaceKey varchar(255), pageTitle varchar(255)")).executeUpdate();
        session.createNativeQuery("create index confluencepro_linkmapping_spacekey_idx on confluencepro_linkmapping_by_title (spaceKey)").executeUpdate();
        this.dontExist = false;
        this.initialized = true;
    }

    private String getSQLLongType(DatabaseProduct databaseProductName) {
        if (DATABASES_SUPPORTING_BIGINT.contains(databaseProductName) || "MariaDB".equals(databaseProductName.getProductName())) {
            return "bigint";
        }
        if (databaseProductName.equals((Object)DatabaseProduct.ORACLE)) {
            return "number(19,0)";
        }
        return "numeric(19,0)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String get(long pageId) {
        String ref;
        if (this.needsConversion) {
            this.convertOldMappings();
        }
        if (this.areTableAbsent()) {
            return null;
        }
        Session session = this.beginTransaction();
        try {
            ref = LinkMappingStore.getOneString(session.createNativeQuery("select reference from confluencepro_linkmapping_by_id where pageId = ?").setParameter(1, (Object)pageId));
        }
        finally {
            this.endTransaction(false);
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String get(String spaceKey, String pageTitle) {
        String ref;
        if (this.needsConversion) {
            this.convertOldMappings();
        }
        if (this.areTableAbsent()) {
            return null;
        }
        Session session = this.beginTransaction();
        try {
            ref = LinkMappingStore.getOneString(session.createNativeQuery("select reference from confluencepro_linkmapping_by_title where spaceKey = ? and pageTitle = ?").setParameter(1, (Object)spaceKey).setParameter(2, (Object)pageTitle));
        }
        finally {
            this.endTransaction(false);
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getSpaceForReference(String reference) {
        String ref;
        if (this.needsConversion) {
            this.convertOldMappings();
        }
        if (this.areTableAbsent()) {
            return null;
        }
        Session session = this.beginTransaction();
        try {
            ref = LinkMappingStore.getOneString(session.createNativeQuery("select spaceKey from confluencepro_linkmapping_by_title where reference = ?").setParameter(1, (Object)reference));
        }
        finally {
            this.endTransaction(false);
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getShortestReferenceForSpace(String spaceKey) {
        if (this.needsConversion) {
            this.convertOldMappings();
        }
        Session session = this.beginTransaction();
        try {
            if (this.areTableAbsent(session)) {
                String string = null;
                return string;
            }
            String string = LinkMappingStore.getOneString(session.createNativeQuery("select reference from (select reference from confluencepro_linkmapping_by_title where spaceKey = ? order by length(reference) asc limit 1) sub").setParameter(1, (Object)spaceKey));
            return string;
        }
        finally {
            this.endTransaction(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getShortestReferenceForSpaceByReference(String reference) {
        String ref;
        if (this.needsConversion) {
            this.convertOldMappings();
        }
        if (this.areTableAbsent()) {
            return null;
        }
        Session session = this.beginTransaction();
        try {
            ref = LinkMappingStore.getOneString(session.createNativeQuery("select reference from confluencepro_linkmapping_by_title where spaceKey in (select spaceKey from confluencepro_linkmapping_by_title where reference = ? limit 1) order by length(reference) asc limit 1").setParameter(1, (Object)reference));
        }
        finally {
            this.endTransaction(false);
        }
        return ref;
    }

    private static String getOneString(Query<?> q) {
        Object r;
        Optional res = q.getResultStream().findFirst();
        if (res.isPresent() && (r = res.get()) instanceof String) {
            return (String)r;
        }
        return null;
    }

    public void removeSpaces(Collection<String> spaces) {
        if (this.areTableAbsent()) {
            return;
        }
        Session session = this.beginTransaction();
        try {
            session.createNativeQuery("delete from confluencepro_linkmapping_by_id where reference in (select reference from confluencepro_linkmapping_by_title where spaceKey in (:spaces))").setParameterList(SPACES, spaces).executeUpdate();
            session.createNativeQuery("delete from confluencepro_linkmapping_by_title where spaceKey in (:spaces)").setParameter(SPACES, spaces).executeUpdate();
            this.maybeDropTables(session);
        }
        finally {
            this.endTransaction(true);
        }
    }

    private void maybeDropTables(Session session) {
        if (session.createNativeQuery("select 1 from confluencepro_linkmapping_by_id limit 1").getResultStream().findFirst().isPresent()) {
            return;
        }
        if (session.createNativeQuery("select 1 from confluencepro_linkmapping_by_title limit 1").getResultStream().findFirst().isPresent()) {
            return;
        }
        this.empty(session);
    }

    public void empty() {
        Session session = this.beginTransaction();
        try {
            this.empty(session);
        }
        finally {
            this.endTransaction(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEntryCount() {
        long res = 0L;
        Session session = this.beginTransaction();
        try {
            if (!this.areTableAbsent(session)) {
                res += this.getCount(session, TABLE_BY_ID);
                res += this.getCount(session, TABLE_BY_TITLE);
            }
        }
        finally {
            this.endTransaction(true);
        }
        return res;
    }

    private long getCount(Session session, String table) {
        Object res;
        Optional r = session.createNativeQuery("select count(reference) from " + table).getResultStream().findFirst();
        if (r.isPresent() && (res = r.get()) instanceof Number) {
            return ((Number)res).longValue();
        }
        this.logger.error("Could not count entries in confluencepro_linkmapping_by_id");
        return 0L;
    }

    private void empty(Session session) {
        session.createNativeQuery("drop table confluencepro_linkmapping_by_id").executeUpdate();
        session.createNativeQuery("drop table confluencepro_linkmapping_by_title").executeUpdate();
        this.dontExist = true;
    }

    public void add(Session session, long pageId, String spaceKey, String pageTitle, EntityReference reference) {
        String ref = (String)this.serializer.serialize(reference, new Object[0]);
        this.add(session, pageId, ref);
        this.add(session, spaceKey, pageTitle, ref);
    }

    public void add(Session session, long pageId, String reference) {
        this.createTableIfNotExists(session);
        session.createNativeQuery("delete from confluencepro_linkmapping_by_id where pageId = ?").setParameter(1, (Object)pageId).executeUpdate();
        session.createNativeQuery("insert into confluencepro_linkmapping_by_id (pageId, reference) values (?,?)").setParameter(1, (Object)pageId).setParameter(2, (Object)reference).executeUpdate();
    }

    public void add(Session session, String spaceKey, String pageTitle, String reference) {
        this.createTableIfNotExists(session);
        session.createNativeQuery("delete from confluencepro_linkmapping_by_title where spaceKey = ? and pageTitle = ?").setParameter(1, (Object)spaceKey).setParameter(2, (Object)pageTitle).executeUpdate();
        session.createNativeQuery("insert into confluencepro_linkmapping_by_title (spaceKey, pageTitle, reference) values(?,?,?)").setParameter(1, (Object)spaceKey).setParameter(2, (Object)pageTitle).setParameter(3, (Object)reference).executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertOldMappings() {
        List<Object[]> res = this.getOldMappings();
        if (res == null || res.isEmpty()) {
            this.needsConversion = false;
            return;
        }
        ArrayList<XWikiDocument> documentsToDelete = new ArrayList<XWikiDocument>(res.size());
        Session session = this.beginTransaction();
        try {
            this.logger.info("Migrating old link mapping documents to the new SQL storage");
            int i = 0;
            for (Object[] line : res) {
                XWikiDocument d = (XWikiDocument)line[0];
                this.logger.info("Converting [{}] ({}/{})", new Object[]{d, ++i, res.size()});
                String spaceKey = LinkMappingStore.getSpaceKey(line);
                if (this.isSpaceFoundInConfluencePageClassObj(spaceKey)) {
                    this.logger.info("ConfluencePageClass objects found for the related space, skipping import of [{}]", (Object)d);
                    documentsToDelete.add(d);
                    continue;
                }
                try {
                    boolean isPageIdMapping = d.getDocumentReference().getName().endsWith(IDS_SUFFIX);
                    this.parseOldMapping(session, (String)line[2], spaceKey, isPageIdMapping);
                    documentsToDelete.add(d);
                }
                catch (Exception e) {
                    this.logger.error("Failed to convert [{}], the document will not be removed", (Object)d);
                }
            }
        }
        finally {
            this.endTransaction(true);
        }
        this.removeOldMappings(documentsToDelete);
        this.needsConversion = false;
    }

    private void removeOldMappings(List<XWikiDocument> documentsToDelete) {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        this.logger.info("Removing the [{}] old link mapping documents we managed to convert", (Object)documentsToDelete.size());
        int i = 0;
        for (XWikiDocument notLoadedDocument : documentsToDelete) {
            this.logger.info("Removing [{}] ({}/{})", new Object[]{notLoadedDocument, ++i, documentsToDelete.size()});
            try {
                XWikiDocument d = context.getWiki().getDocument(notLoadedDocument.getDocumentReference(), context);
                context.getWiki().deleteDocument(d, context);
            }
            catch (XWikiException e) {
                this.logger.error("Could not remove old mapping document [{}]", (Object)notLoadedDocument, (Object)e);
            }
        }
        this.logger.info("Finished removing old link mapping documents");
    }

    private static String getSpaceKey(Object[] line) {
        String spaceKey = (String)line[1];
        if (spaceKey.endsWith(IDS_SUFFIX)) {
            spaceKey = spaceKey.substring(0, spaceKey.length() - 4);
        }
        return spaceKey;
    }

    private List<Object[]> getOldMappings() {
        try {
            return this.queryManager.createQuery("select doc, spaceProp.value, mappingProp.value from XWikiDocument doc, BaseObject o, StringProperty spaceProp, LargeStringProperty mappingProp where doc.fullName = o.name and o.className = 'ConfluenceMigratorPro.Code.LinkMappingStateSpaceClass' and o.id = spaceProp.id.id and spaceProp.id.name = 'spaceKey' and o.id = mappingProp.id.id and mappingProp.id.name = 'mapping' order by doc.fullName", "hql").execute();
        }
        catch (QueryException e) {
            this.logger.error("Failed to find the old mappings", (Throwable)e);
            return null;
        }
    }

    private boolean isSpaceFoundInConfluencePageClassObj(String spaceKey) {
        try {
            return !this.queryManager.createQuery("select 1 from BaseObject o, StringProperty p where o.className = 'Confluence.Code.ConfluencePageClass' and o.id = p.id.id and p.id.name = 'space' and p.value = :space", "hql").setLimit(1).bindValue("space", (Object)spaceKey).execute().isEmpty();
        }
        catch (QueryException e) {
            this.logger.error("Failed to determine whether data on space [{}] is already present in the wiki", (Object)spaceKey, (Object)e);
            return false;
        }
    }

    private void parseOldMapping(Session session, String mapping, String spaceKey, boolean pageIds) {
        try {
            Map m = (Map)new ObjectMapper().readValue(mapping, LM_TYPE_REF);
            for (Map.Entry entry : m.entrySet()) {
                String ref = (String)entry.getValue();
                if (pageIds) {
                    this.add(session, Long.parseLong((String)entry.getKey()), ref);
                    continue;
                }
                this.add(session, spaceKey, (String)entry.getKey(), ref);
            }
        }
        catch (JsonProcessingException e) {
            this.logger.error("Failed to parse old mapping", (Throwable)e);
        }
    }
}

