/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.pro.internal.resolvers;

import com.xwiki.pro.internal.resolvers.LinkMappingStore;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.confluence.resolvers.ConfluencePageIdResolver;
import org.xwiki.contrib.confluence.resolvers.ConfluencePageTitleResolver;
import org.xwiki.contrib.confluence.resolvers.ConfluenceSpaceKeyResolver;
import org.xwiki.contrib.confluence.resolvers.ConfluenceSpaceResolver;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
@Singleton
@Named(value="prolinkmapping")
public class ProLinkMappingConfluenceResolver
implements ConfluencePageIdResolver,
ConfluencePageTitleResolver,
ConfluenceSpaceKeyResolver,
ConfluenceSpaceResolver {
    @Inject
    private EntityReferenceResolver<String> resolver;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private LinkMappingStore store;

    public EntityReference getDocumentById(long id) {
        String ref = this.store.get(id);
        return this.resolveDocument(ref);
    }

    public EntityReference getDocumentByTitle(String spaceKey, String title) {
        String ref = this.store.get(spaceKey, title);
        return this.resolveDocument(ref);
    }

    private EntityReference resolveDocument(String ref) {
        if (ref == null) {
            return null;
        }
        return this.resolver.resolve((Object)ref, EntityType.DOCUMENT, new Object[0]);
    }

    private EntityReference resolveSpace(String ref) {
        if (ref == null) {
            return null;
        }
        return this.resolver.resolve((Object)ref, EntityType.SPACE, new Object[0]);
    }

    public EntityReference getSpaceByKey(String spaceKey) {
        String ref = this.store.getShortestReferenceForSpace(spaceKey);
        return this.resolveSpace(ref);
    }

    public EntityReference getSpace(EntityReference reference) {
        String ref = this.store.getShortestReferenceForSpaceByReference((String)this.serializer.serialize(reference, new Object[0]));
        return this.resolveSpace(ref);
    }

    public String getSpaceKey(EntityReference reference) {
        return this.store.getSpaceForReference((String)this.serializer.serialize(reference, new Object[0]));
    }
}

