/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.referencefixer.internal;

import com.xwiki.confluencepro.referencefixer.BrokenRefType;
import java.util.ArrayList;
import java.util.List;
import org.xwiki.job.AbstractRequest;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;

public class ReferenceFixingJobRequest
extends AbstractRequest {
    private static final long serialVersionUID = 1L;
    private final List<EntityReference> migrationReferences;
    private final List<EntityReference> spaceReferences;
    private final String[] baseURLs;
    private final BrokenRefType brokenRefType;
    private final boolean exhaustive;
    private final boolean updateInPlace;
    private final boolean dryRun;
    private final DocumentReference statusDocumentReference;

    public ReferenceFixingJobRequest(DocumentReference statusDocumentReference, List<EntityReference> migrationReferences, List<EntityReference> spaceReferences, String[] baseURLs, BrokenRefType brokenRefType, boolean exhaustive, boolean updateInPlace, boolean dryRun) {
        this.migrationReferences = migrationReferences;
        this.spaceReferences = spaceReferences;
        this.baseURLs = baseURLs;
        this.brokenRefType = brokenRefType;
        this.exhaustive = exhaustive;
        this.updateInPlace = updateInPlace;
        this.dryRun = dryRun;
        this.statusDocumentReference = statusDocumentReference;
        List<String> jobId = ReferenceFixingJobRequest.getJobId((EntityReference)statusDocumentReference);
        this.setId(jobId);
    }

    public static List<String> getJobId(EntityReference statusDocumentReference) {
        ArrayList<String> jobId = new ArrayList<String>();
        jobId.add("confluence");
        jobId.add("referencefixing");
        for (EntityReference er : statusDocumentReference.getReversedReferenceChain()) {
            jobId.add(er.getName());
        }
        return jobId;
    }

    boolean isExhaustive() {
        return this.exhaustive;
    }

    BrokenRefType getBrokenRefType() {
        return this.brokenRefType;
    }

    List<EntityReference> getMigrationReferences() {
        return this.migrationReferences;
    }

    List<EntityReference> getSpaceReferences() {
        return this.spaceReferences;
    }

    String[] getBaseURLs() {
        return this.baseURLs;
    }

    boolean isUpdateInPlace() {
        return this.updateInPlace;
    }

    boolean isDryRun() {
        return this.dryRun;
    }

    DocumentReference getStatusDocumentReference() {
        return this.statusDocumentReference;
    }
}

