/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.referencefixer.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiAttachmentContent;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xwiki.confluencepro.referencefixer.internal.ConfluenceReferenceFixer;
import com.xwiki.confluencepro.referencefixer.internal.ReferenceFixingJobRequest;
import com.xwiki.confluencepro.referencefixer.internal.Stats;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.job.AbstractJob;
import org.xwiki.job.DefaultJobStatus;
import org.xwiki.job.GroupedJob;
import org.xwiki.job.JobGroupPath;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
@Named(value="confluence.referencefixing")
public class ReferenceFixingJob
extends AbstractJob<ReferenceFixingJobRequest, DefaultJobStatus<ReferenceFixingJobRequest>>
implements GroupedJob {
    static final String JOBTYPE = "confluence.referencefixing";
    private static final JobGroupPath GROUP = new JobGroupPath(Arrays.asList("confluencemigratorpro", "referencefixing"));
    private static final LocalDocumentReference REFERENCE_FIXING_CLASS = new LocalDocumentReference(List.of("ConfluenceMigratorPro", "ReferenceFixer", "Code"), "ReferenceFixingSessionClass");
    private static final String EXECUTED = "executed";
    @Inject
    private ConfluenceReferenceFixer referenceFixer;
    @Inject
    private Provider<XWikiContext> contextProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInternal() throws Exception {
        DocumentReference statusDocumentReference = ((ReferenceFixingJobRequest)this.request).getStatusDocumentReference();
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        XWiki wiki = context.getWiki();
        XWikiDocument document = wiki.getDocument(statusDocumentReference, context);
        document.setIntValue((EntityReference)REFERENCE_FIXING_CLASS, EXECUTED, 2);
        wiki.saveDocument(document, "Start session", context);
        this.logger.info("Starting reference fixing job");
        Stats s = null;
        try {
            s = this.referenceFixer.fixDocuments(((ReferenceFixingJobRequest)this.request).getMigrationReferences(), ((ReferenceFixingJobRequest)this.request).getSpaceReferences(), ((ReferenceFixingJobRequest)this.request).getBaseURLs(), ((ReferenceFixingJobRequest)this.request).getBrokenRefType(), ((ReferenceFixingJobRequest)this.request).isExhaustive(), ((ReferenceFixingJobRequest)this.request).isUpdateInPlace(), ((ReferenceFixingJobRequest)this.request).isDryRun());
        }
        catch (Exception e) {
            document = wiki.getDocument(statusDocumentReference, context);
            document.setIntValue((EntityReference)REFERENCE_FIXING_CLASS, EXECUTED, 3);
            wiki.saveDocument(document, "End failed session", context);
            this.logger.error("Reference fixing job failed with an exception", (Throwable)e);
        }
        finally {
            document = wiki.getDocument(statusDocumentReference, context);
            document.setIntValue((EntityReference)REFERENCE_FIXING_CLASS, EXECUTED, 1);
            if (s != null) {
                this.addAttachment("stats.json", s.toJSON(), document);
                this.addAttachment("failedReferences.tsv", s.getFailedReferencesTSV(), document);
            }
            wiki.saveDocument(document, "End session", context);
        }
        this.logger.info("Finished reference fixing job");
    }

    private void addAttachment(String name, String content, XWikiDocument document) {
        XWikiAttachment a = new XWikiAttachment(document, name);
        XWikiAttachmentContent attachmentContent = new XWikiAttachmentContent(a);
        try {
            attachmentContent.setContent((InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            this.logger.error("Could not save [{}]", (Object)name, (Object)e);
        }
        a.setAttachment_content(attachmentContent);
        document.setAttachment(a);
    }

    public JobGroupPath getGroupPath() {
        return GROUP;
    }

    public String getType() {
        return JOBTYPE;
    }
}

